## 字符串类型

## char 和 varchar

1、char 定长字符

char(L) L 代表字符数（0-255）

2、varchar 变长字符

varchar(L) L 代表字符数（0-65535）

每个 varchar 数据，都会增加 1-2 个字节来保存数据所占用的空间长度

- 数据本身小于 127 个字符，额外开销 1 个字节
- 数据本身大于 127 个字符，额外开销 2 个字节

char 和 varchar 对比, utf8，一个字符都会占用 3 个字节

| 存储数据 | char(2) | varchar(2) | char 所占字节 | varchar 所占字节 |
| -------- | ------- | ---------- | ------------- | ---------------- |
| A        | A       | A          | `2 * 3 = 6`   | `1 * 3 + 1 = 4`  |
| AB       | AB      | AB         | `2 * 3 = 6`   | `2 * 3 + 1 = 7`  |

char 和 varchar 区别

- char 一定会使用指定的空间，varchar 根据数据来定空间
- char 的数据查询效率比 varchar 高，varchar 需要通过后面的记录数来计算

char 和 varchar 选择

- 如果确定数据的长度，使用 char
- 不确定数据的长度，使用 varchar
- 如果数据长度超过 255 个字符，一般使用 text

## text 文本类型

- text 存储普通的字符文本
- blob 存储二进制文件（图片，文件），一般不使用，通常使用一个连接来指向对应的文件

| 类型       | 字节数   | 实际存储数据量 |
| ---------- | -------- | -------------- |
| tinytext   | 1 个字节 | `2^8 + 1`      |
| text       | 2 个字节 | `2^16 + 2`     |
| mediumtext | 3 个字节 | `2^24 + 3`     |
| longtext   | 4 个字节 | `2^32 + 4`     |

注意：

1、不用刻意选择 text 类型，系统会自动根据存储的数据长度来选择合适的文本类型

2、如果数据超过 255 个字符，一定选择 text

## MySQL记录长度

MySQL规定：记录长度(record == 行row), 总长度不能超过65535个字节

varchar 能够存储的理论值65535个字符，字符在不同的字符集下可能占用多个字节

varchar处理存储数据本身要占用空间，还需要额外的空间来保存记录长度

证明：varchar在MySQL中能够达到的理论值
```
utf8 65535 / 3 = 21845，需要2个字节保存长度
gbk 65535 / 2 = 32767...1，需要2个字节保存长度
```

```sql
create table my_utf8(
  name varchar(21844)
) charset utf8;

create table my_gbk(
  name varchar(32766)
) charset gbk;
```
