# 笔记: Golang 核心编程

学习资料

- 视频适合零基础（1.9.2）：[【尚硅谷】Golang 入门到实战教程](https://www.bilibili.com/video/BV1ME411Y71o)

- 视频适合有基础（1.19）：[golang 入门到项目实战](https://www.bilibili.com/video/BV1zR4y1t7Wj)

## 目录

### 第一章 语言基础

- [1.1、Golang 概述](/blog/golang/golang-start.md)

- [1.2、Golang 环境安装](/blog/golang/golang-install.md)

- [1.3、Golang 运行代码](/blog/golang/golang-run.md)

- [1.4、Golang 项目管理](/blog/golang/golang-project.md)

### 第二章 基本语法

- [2.1、Golang 标识符、关键字、命名规则](/blog/golang/golang-identifier.md)

- [2.2、Golang 变量](/blog/golang/golang-variable.md)

- [2.3、Golang 常量](/blog/golang/golang-constant.md)

- [2.4、Golang 数据类型](/blog/golang/golang-type.md)

- [2.5、Golang 格式化输出](/blog/golang/golang-format.md)

- [2.6、Golang 运算符](/blog/golang/golang-operator.md)

- [2.7、Golang 流程控制](/blog/golang/golang-process.md)

### 第三章 数据结构

- [3.1、Golang 数组 array](/blog/golang/golang-array.md)

- [3.2、Golang 切片 slice](/blog/golang/golang-slice.md)

- [3.3、Golang map](/blog/golang/golang-map.md)

- [3.4、Golang 函数 func](/blog/golang/golang-function.md)

- [3.5、Golang 指针 pointer ](/blog/golang/golang-pointer.md)

- [3.6、Golang 结构体 struct](/blog/golang/golang-struct.md)

- [3.7、Golang 接口 interface](/blog/golang/golang-interface.md)

- [3.8、Golang 包 package](/blog/golang/golang-package.md)

### 第四章 Golang 并发编程

- [4.1、Golang 并发编程-协程](/blog/golang/golang-concurrency-goroutines.md)

- [4.2、Golang 并发编程-channel](/blog/golang/golang-concurrency-channel.md)

- [4.3、Golang 并发编程-WaitGroup 实现同步](/blog/golang/golang-concurrency-WaitGroup.md)

- [4.4、Golang 并发编程-runtime 包](/blog/golang/golang-concurrency-runtime.md)

- [4.5、Golang 并发编程-Mutex 互斥锁实现同步](/blog/golang/golang-concurrency-Mutex.md)

- [4.6、Golang 并发编程-atomic 原子操作](/blog/golang/golang-concurrency-atomic.md)

- [4.7、Golang 并发编程-select switch](/blog/golang/golang-concurrency-select-switch.md)

- [4.8、Golang 并发编程-Timer 定时器](/blog/golang/golang-concurrency-Timer.md)

- [4.9、Golang 并发编程-Ticker 周期执行](/blog/golang/golang-concurrency-Ticker.md)

### 第五章 Golang 标准库

- [5.1、Golang 标准库-os](/blog/golang/golang-standard-os.md)

- [5.2、Golang 标准库-io 输入输出](/blog/golang/golang-standard-io.md)

- [5.3、Golang 标准库-ioutil](/blog/golang/golang-standard-ioutil.md)

- [5.4、Golang 标准库-bufio](/blog/golang/golang-standard-bufio.md)

- [5.5、Golang 标准库-log](/blog/golang/golang-standard-log.md)

- [5.6、Golang 标准库-builtin](/blog/golang/golang-standard-builtin.md)

- [5.7、Golang 标准库-bytes](/blog/golang/golang-standard-bytes.md)

- [5.8、Golang 标准库-errors](/blog/golang/golang-standard-errors.md)

- [5.9、Golang 标准库-sort](/blog/golang/golang-standard-sort.md)

- [5.10、Golang 标准库-time](/blog/golang/golang-standard-time.md)

- [5.11、Golang 标准库-json](/blog/golang/golang-standard-json.md)

- [5.12、Golang 标准库-xml](/blog/golang/golang-standard-xml.md)

- [5.13、Golang 标准库-math](/blog/golang/golang-standard-math.md)

### 第六章 Golang 操作数据库

- [Golang 操作 MySQL 数据库](/blog/golang/golang-mysql.md)

- [Golang 操作 MongoDB 数据库](/blog/golang/golang-mongo.md)

- [Golang ORM 库 gorm](/blog/golang/golang-gorm.md)

### 第七章 Go 语言 Web 框架

- [Go 语言 Web 框架之 gin](/blog/golang/golang-gin.md)

https://www.bilibili.com/video/BV1ME411Y71o?p=27&spm_id_from=pageDriver&vd_source=efbb4dc944fa761b6e016ce2ca5933da

https://www.bilibili.com/video/BV1zR4y1t7Wj?p=119&spm_id_from=pageDriver&vd_source=efbb4dc944fa761b6e016ce2ca5933da
