import axios from "axios";

export const AXIOS = axios.create({
  // baseURL: "/login/api",
  baseURL: ""
})

AXIOS.interceptors.request.use(
  function(response: any) {
    response.headers["Authorization"] = sessionStorage.getItem("token");
    return response;
  },
  function(error) {
    console.log(error)
    return false;
  }
)

AXIOS.interceptors.response.use(
  function(request) {
    return request.data
  },
  function(error) {
    return Promise.reject(error);
  }
)