import {
  AXIOS
} from './interceptors';
export const method = {
  get(addr: string) {
    return AXIOS.get(addr);
  },
  post(addr: string, datas: { [key: string]: any }) {
    return AXIOS.post(addr,
      datas,
    );
  },
  put(addr: string, datas: { [key: string]: any }) {
    return AXIOS.put(addr, {
      ...datas,
    });
  },
  delete(addr: string, id: number | string) {
    return AXIOS.delete(`${addr}/${id}`);
  }
}
