//获取本地图片/视频链接

async function preview(e: any) {
    const buffer = await e.target.files[0].arrayBuffer();
 
    return URL.createObjectURL(new Blob([buffer]));


}

/**
 
 * 截取本地视频第一帧
 
 * 需要传入本地视频播放的video
 
 * @intercpt
 
*/

//calssname==是渲染视频的video的id

function intercpt(calssname: HTMLElement) {

    const canvas: any = document.createElement('canvas')

    const ratio = calssname.offsetHeight / 9 / 16

    canvas.width = Math.ceil(calssname.offsetHeight / 9) * 16

    canvas.height = calssname.offsetHeight

    canvas.getContext('2d').drawImage(calssname, 0, 0, canvas.width, canvas.height)

    return canvas.toDataURL('image/png', 1.0)

}
/** 
 * 截取本地视频某一帧
 * @ramerate
*/
function ramerate(url: string, width: string, height: string,mun:number) {
    return new Promise(function (resolve, reject) {
        const video = document.createElement('video')
        video.currentTime =mun|| 8 // 指定帧数
        video.setAttribute('mut', 'true')
        video.setAttribute('crossOrigin', 'anonymous') // 处理跨域
        video.setAttribute('crossOrigin', 'anonymous') // 处理跨域
        video.setAttribute('src', url)
        video.setAttribute('x5-video-player-type', 'h5-page')
        video.setAttribute('preload', 'metadata')
        video.setAttribute('width', width)
        video.setAttribute('height', height)
        video.addEventListener('loadeddata', () => {
            const canvas = document.createElement('canvas') as any
            const width = video.width // canvas的尺寸和图片一样
            const height = video.height
            canvas.width = width
            canvas.height = height
            canvas.getContext('2d').drawImage(video, 0, 0, width, height) // 绘制canvas
            var dataURL = canvas.toDataURL('image/jpeg') // 转换为base64 
            console.log(dataURL);
            resolve(dataURL);
        })
    })
}
/** 
 * 截取本地图片第一帧转化为文件类型
 * @convert
*/
function convert(url: any, name: string) {
    // console.log(url);
    var arr = url.split(","),
        mime = arr[0].match(/:(.*?);/)[1],
        bstr = atob(arr[1]),
        n = bstr.length,
        u8arr = new Uint8Array(n);
    while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
    }
    console.log(new File([u8arr], name || 'png', { type: mime }));
    return new File([u8arr], name || 'png', { type: mime })
}

export { preview, intercpt, convert, ramerate }