import { createApp } from 'vue'
import App from './App.vue'
import 'element-plus/theme-chalk/index.css'
import './assets/main.css'
import ElementPlus from 'element-plus'
import "@element-plus/icons-vue"
createApp(App).use(ElementPlus).mount('#app')


const puppeteer = require('puppeteer');
const path = require('path');
const fs = require('fs');

(async () => {
  const browser = await puppeteer.launch();
  const page = await browser.newPage();
  await page.goto('https://example.com/upload-form');

  const fileInputHandle = await page.$('#file-input');
  const folderPath = 'path/to/folder'; // 替换成你的图片文件夹路径

  const files = fs.readdirSync(folderPath).map(filename => {
    const filePath = path.join(folderPath, filename);
    return { name: filename, path: filePath };
  });

  for (const file of files) {
    const formData = new FormData();
    formData.append('file', fs.createReadStream(file.path), file.name);
    await fileInputHandle.uploadFile(file.path);
    await page.evaluate(() => {
      const fileInput = document.querySelector('#file-input');
      fileInput.files = formData;
      fileInput.dispatchEvent(new Event('change', { bubbles: true }));
    });
    await page.waitForSelector('.upload-success-message');
  }

  await browser.close();
})();

















const fs = require('fs');
const path = require('path');

const folderPath = 'path/to/folder'; // 替换成你的文件夹路径
const files = fs.readdirSync(folderPath).filter(file => fs.statSync(path.join(folderPath, file)).isFile());

const shuffle = arr => {
  for (let i = arr.length - 1; i > 0; i--) {
    const j = Math.floor(Math.random() * (i + 1));
    [arr[i], arr[j]] = [arr[j], arr[i]];
  }
  return arr;
};

const chunks = (arr, size) => {
  const result = [];
  for (let i = 0; i < arr.length; i += size) {
    result.push(arr.slice(i, i + size));
  }
  return result;
};

const randomChunks = (arr, numChunks) => {
  const shuffled = shuffle(arr);
  const chunkSize = Math.ceil(shuffled.length / numChunks);
  return chunks(shuffled, chunkSize);
};

const splitInto = (folderPath, numChunks) => {
  const files = fs.readdirSync(folderPath).filter(file => fs.statSync(path.join(folderPath, file)).isFile());
  return randomChunks(files, numChunks);
};

console.log(splitInto(folderPath, 10)); // 将文件夹分成 10 份，并输出结果


。该模块支持读取、写入 Excel 文件，并且提供了方便的 API 来操作 Excel 表格数据。

以下是几个基本的示例，来演示如何使用 xlsx 模块读取、写入 Excel 文件。

读取 Excel 文件：

javascript
复制
插入
const xlsx = require('xlsx');

const workbook = xlsx.readFile('path/to/file.xlsx'); // 读取 Excel 文件
const sheetName = workbook.SheetNames[0]; // 获取第一个工作表的名称
const sheet = workbook.Sheets[sheetName]; // 获取第一个工作表
const data = xlsx.utils.sheet_to_json(sheet); // 将工作表数据转换为 JSON 对象

console.log(data); // 输出工作表数据
复制
插入
写入 Excel 文件：

javascript
复制
插入
const xlsx = require('xlsx');

const data = [
  { ID: 1, Name: 'Alice', Age: 20 },
  { ID: 2, Name: 'Bob', Age: 25 },
  { ID: 3, Name: 'Charlie', Age: 30 }
];

const sheet = xlsx.utils.json_to_sheet(data); // 将 JSON 对象转换为工作表
const workbook = xlsx.utils.book_new(); // 创建新的工作簿
xlsx.utils.book_append_sheet(workbook, sheet, 'Sheet1'); // 添加工作表到工作簿
xlsx.writeFile(workbook, 'path/to/file.xlsx'); // 写入 Excel 文件
复制
插入
使用 Excel 作为数据库，可以将每个工作表看作一个数据表，每个工作表中的行看作数据记录，每个工作表中的列看作数据字段。在使用 Excel 做数据库时，需要注意以下几点：

确定好每个工作表的结构，即数据字段和数据类型。
使用 xlsx 模块读取工作表数据时，需要注意数据类型的转换。
使用 xlsx 模块写入工作表数据时，需要根据数据类型将数据转换为合适的格式。
以下是一个简单的示例，来演示如何使用 Excel 做数据库：

javascript
复制
插入
const xlsx = require('xlsx');

const filename = 'path/to/database.xlsx';
const worksheetName = 'users';

const getUserById = id => {
  const workbook = xlsx.readFile(filename);
  const sheet = workbook.Sheets[worksheetName];
  const data = xlsx.utils.sheet_to_json(sheet, { header: 1, range: 1 }); // 读取数据并转换为 JSON 对象
  const headers = data[0];
  const index = headers.indexOf('ID');
  const row = data.find(row => row[index] === id);
  if (!row) {
    return null;
  }
  const user = {};
  headers.forEach((header, i) => user[header] = row[i]);
  return user;
};

const addUser = user => {
  const workbook = xlsx.readFile(filename);
  const sheet = workbook.Sheets[worksheetName];
  const headers = Object.keys(user);
  const data = xlsx.utils.sheet_to_json(sheet, { header: 1, range: 1 }); // 读取数据并转换为 JSON 对象
  const maxId = data.reduce((max, row) => Math.max(max, row[0]), 0); // 计算最大 ID
  const newRow = headers.map(header => user[header] || ''); // 创建新行数据
  newRow[0] = maxId + 1; // 设置新行的 ID
  data.push(newRow); // 将新行添加到数据中
  const newSheet = xlsx.utils.json_to_sheet(data, { header: headers, skipHeader: true }); // 将数据转换为工作表
  xlsx.utils.book_append_sheet(workbook, newSheet, worksheetName); // 替换原有工作表
  xlsx.writeFile(workbook, filename); // 写入 Excel 文件
};

addUser({ Name: 'David', Age: 35 }); // 添加用户
console.log(getUserById(4)); // 获取用户
复制
插入
上面的示例中，我们将一个 Excel 工作表作为用户数据库，包含 ID、Name 和 Age 三个字段。其中，getUserById 函数根据用户 ID 获取用户信息，addUser 函数添加新用户。在添加新用户时，我们需要先读取数据，计算新用户的 ID，然后创建新行数据，将新行添加到数据中，最后将数据转换为工作表，并替换原有工作表。

需要注意的是，在读取数据时，我们指定了 header: 1, range: 1 选项，这样可以只读取第一行数据（即数据字段），并排除第一行之前的数据。这样可以避免读取 Excel 表格中的其他无关数据。





可以使用 el-dialog 和 el-input 组件来实现一个类似于 Windows 系统选择文件路径弹窗的 UI 功能。具体实现步骤如下：

在 nuxt.config.js 中引入 element-plus 组件库：
javascript
复制
插入
export default {
  modules: [
    'element-plus/nuxt'
  ],
  // ...
}
复制
插入
在需要使用的页面或组件中，使用 el-dialog 和 el-input 组件来实现 UI：
html
复制
插入
<template>
  <div>
    <el-button @click="showDialog">选择文件夹</el-button>
    <el-dialog :visible.sync="dialogVisible">
      <el-input v-model.lazy="path" placeholder="请选择文件夹" :value="path" readonly></el-input>
      <el-button @click="browse">浏览...</el-button>
      <span slot="footer" class="dialog-footer">
        <el-button @click="dialogVisible = false">取 消</el-button>
        <el-button type="primary" @click="selectPath">确 定</el-button>
      </span>
    </el-dialog>
  </div>
</template>

<script>
export default {
  data() {
    return {
      dialogVisible: false,
      path: ''
    }
  },
  methods: {
    showDialog() {
      this.dialogVisible = true;
    },
    browse() {
      // TODO: 打开文件夹选择对话框，获取文件夹路径
    },
    selectPath() {
      // TODO: 返回文件夹路径，关闭对话框
    }
  }
};
</script>
复制
插入
在 browse 方法中，可以使用 Node.js 的 remote 模块来打开文件夹选择对话框，获取文件夹路径：
javascript
复制
插入
const { remote } = require('electron');

browse() {
  const dialog = remote.dialog;
  const result = dialog.showOpenDialogSync({
    properties: ['openDirectory']
  });
  if (result) {
    this.path = result[0];
  }
}
复制
插入
在上面的代码中，我们使用 remote.dialog.showOpenDialogSync 方法打开文件夹选择对话框，指定 properties: ['openDirectory'] 选项来只选择文件夹。如果用户选择了文件夹，则将文件夹路径赋值给 path 变量，这样 UI 上的输入框就可以显示选择的文件夹路径了。

在 selectPath 方法中，可以通过 this.path 属性来返回选择的文件夹路径，并关闭对话框：
javascript
复制
插入
selectPath() {
  this.$emit('select', this.path);
  this.dialogVisible = false;
}
复制
插入
在上面的代码中，我们触发了一个 select 事件，并传入选择的文件夹路径，以便其他组件可以监听该事件并获取选择的文件夹路径。同时，我们也关闭了对话框。

这样，就可以实现一个和 Windows 系统选择文件路径弹如何窗类似的 UI 功能了