import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
// 自动导入vue中hook reactive ref等
import AutoImport from "unplugin-auto-import/vite"
import Components from 'unplugin-vue-components/vite';
import { VantResolver } from 'unplugin-vue-components/resolvers';

import path from "path";
const pathSrc = path.resolve(__dirname, "./src");

export default defineConfig({
  resolve:{
    alias: {
      '@': pathSrc,
      },
  },
  plugins: [
    vue(),
    AutoImport({
			//安装两行后你会发现在组件中不用再导入ref，reactive等
			imports: ['vue', 'vue-router',"@vueuse/core"],
      //存放的位置
			dts: "src/types/auto-import.d.ts",
		}),
    Components({
      // 按需导入vant组件
      resolvers: [VantResolver()],
      // 引入组件的,包括自定义组件  存放的位置
      dts: "src/types/components.d.ts", 
    }),
  ],
  css: {
    preprocessorOptions: { 
      //定义全局scss变量
      scss: {
        additionalData: `@import "@/styles/mixin.scss";@import "@/styles/vant.scss";`
      }
    }
  }
})
