import { createRouter, createWebHashHistory, RouteRecordRaw } from "vue-router";

export const Layout = () => import("@/layout/index.vue")

const routes: RouteRecordRaw[] = [
    {
        path:'/',
        redirect:'/login'
    },
    {
        path: '/login',
        name: 'login',
        component: () => import('@/view/login/index.vue')
    },
    {
        path: "/home",
        component: Layout,
        children: [
            {
                path: '',
                name: 'home',
                component: () => import('@/view/home/index.vue')
            }
        ]
    },
    {
        path: "/book",
        component: Layout,
        children: [
            {
                path: '',
                name: 'book',
                component: () => import('@/view/book/index.vue')
            }
        ]
    },
    {
        path: "/cate",
        component: Layout,
        children: [
            {
                path: '',
                name: 'cate',
                component: () => import('@/view/cate/index.vue')
            }
        ]
    },
    {
        path: "/user",
        component: Layout,
        children: [
            {
                path: '',
                name: 'user',
                component: () => import('@/view/users/index.vue')
            }
        ]
    },
]

const router = createRouter({
    history: createWebHashHistory(),
    routes: routes as RouteRecordRaw[],
})

export default router
