import type { FieldRule } from 'vant'
import { isPassword } from '@/utils/validate'

const nameRules: FieldRule[] = [{ required: true, message: '请输入账号~' }]
const passwordRules: FieldRule[] = [
  { required: true, message: '请输入密码~' },
  { pattern: isPassword(), message: '密码须字母、数字、符号等组合且长度限制6~18位~' }
]
const verifyRules: FieldRule[] = [{ required: true, message: '请输入验证码~' }]


export default {
  nameRules,
  passwordRules,
  verifyRules,
}

