
import GifToCanvas from '../GIFJS/gifToCanvas.js'
// import GIF from "../GIFJS/GIF.js";
import GIF from "gif.js";
const fetchToBlodUrl=(url)=>{
  return new Promise((r)=>{
      fetch(url)
        .then(respone => respone.blob())    // 将响应体转换成blob格式数据
        .then(blob => {
            r(URL.createObjectURL(blob))
        })
        .catch(()=>{r(null)});
  })  
}
const workerScriptUrl= await fetchToBlodUrl('./gif.worker.js')
const cropGifHandle = async(cropperRef, file, cb) => {
    if (cropperRef) {
        if (cb) cb(false, null)
        // vue-cropper 与 cropper.js 的api不同，进行转化
        const cropBoxData = cropperRef.getCropAxis()
        const canvasData = cropperRef.getImgAxis()
        const gifToCanvas = new GifToCanvas(URL.createObjectURL(file), {
            targetOffset: {
                dx: cropBoxData.x1 - canvasData.x1,
                dy: cropBoxData.y1 - canvasData.y1,
                width: canvasData.x2 - canvasData.x1,
                height: canvasData.y2 - canvasData.y1,
                sWidth: cropperRef.cropW,
                sHeight: cropperRef.cropH
            }
        })
        const gif = new GIF({
            workers: 1,
            quality: 2,
            // gif.worker.js放到public 或者 网络地址
            // workerScript: `${window.location.origin}/gif.worker.js`,
            workerScript:workerScriptUrl,
            // transparent: 'rgba(0,0,0,0)',
            background: 'rgba(0,0,0,0)'
        })
        const addFrame = (canvas, delay) => {
            gif.addFrame(canvas, { copy: true, delay })
        }
        gifToCanvas.on('progress', (canvas, delay) => {
            addFrame(canvas, delay)
        })
        gifToCanvas.on('finished', (canvas, delay) => {
            addFrame(canvas, delay)
            gif.render()
        })
        gif.on('finished', (blob) => {
            if (cb) cb(true, blob)
        })
        gifToCanvas.init()
    }
}
export default cropGifHandle