class ListenDomChange {
    // observer
    observer = null
    // performance
    performanceConfig = {}

    constructor() {
        // 初始化为{}
        this.performanceConfig = {}
        // 计算performanceConfig
        // this.calcPerformance()
    }


    getPerformance() {
        return this.performanceConfig
    }

    setPerformance(key, value) {
        this.performanceConfig[key] = value
    }

    calcPerformance() {
        // Time to when activation occurred
        let activationStart =
            performance.getEntriesByType("navigation")[0].activationStart;

        // Time to first paint
        let firstPaint = performance.getEntriesByName("first-paint")[0].startTime;

        // Time to first contentful paint
        let firstContentfulPaint = performance.getEntriesByName(
            "first-contentful-paint",
        )[0].startTime;

        console.log("time to first paint: " + (firstPaint - activationStart));
        console.log(
            "time to first-contentful-paint: " + (firstContentfulPaint - activationStart),
        );
        this.setPerformance('time to first paint', firstPaint - activationStart)
        this.setPerformance('time to first-contentful-paint', firstContentfulPaint - activationStart)

        const entries = performance.getEntriesByType("navigation");
        const that = this
        entries.forEach((entry) => {
            console.log(`${entry.name}: domComplete time: ${entry.domComplete}ms`);
            that.setPerformance('domComplete time', entry.domComplete)

            const domContentLoadedTime =
                entry.domContentLoadedEventEnd - entry.domContentLoadedEventStart;
            console.log(
                `${entry.name}: DOMContentLoaded processing time: ${domContentLoadedTime}ms`,
            );
            that.setPerformance(entry.name, domContentLoadedTime)
        });
    }

    // 监听 dom变化
    mutationAction(listenDom, callbackAction) {
        console.log('listenDom', listenDom)
        // 观察器的配置（需要观察什么变动）
        const config = { attributes: true, childList: true, subtree: true };
        // 当观察到变动时执行的回调函数

        const callback = function (mutationsList, observer) {
            console.log('listenDom', listenDom)
            const renderHeight = listenDom.offsetHeight

            console.log('renderHeight_____________', renderHeight)
            console.log('change_______________', mutationsList)
            // Use traditional 'for loops' for IE 11
            // for (let mutation of mutationsList) {
            //     if (mutation.type === "childList") {
            //         console.log("A child node has been added or removed.");
            //     } else if (mutation.type === "attributes") {
            //         console.log("The " + mutation.attributeName + " attribute was modified.");
            //     }
            // }

            if (parseInt(renderHeight)) {
                // 第一次监听dom 存在高度则判定已经渲染完root节点，不关注子节点
                callbackAction()
                // 停止观察
                observer.disconnect();
            }
        };

        // 创建一个观察器实例并传入回调函数
        const observer = new MutationObserver(callback);
        // 以上述配置开始观察目标节点
        observer.observe(listenDom, config);

    }
}

export {
    ListenDomChange
}