import imaplib,email,os,time,xlrd,threading,json,csv
from datetime import datetime
from email.header import decode_header
from selenium import webdriver
from concurrent.futures import ThreadPoolExecutor

class Email_parse:
    def __init__(self,imap_protocol,port, email_address, password, category="promotions"):
        self.imap_protocol = imap_protocol
        self.email_address = email_address
        self.password = password
        self.category = category
        self.port=port

    def gmail_read(self):
        try:
            # 存储code
            email_store[self.email_address]=self.password
            # 连接到IMAP服务器
            mail = imaplib.IMAP4_SSL(self.imap_protocol, self.port)
            mail.login(self.email_address, self.password)

            # 选择收件箱
            mail.select("INBOX")
            # 关闭连接
            mail.close()
            mail.logout()
            success_email.append(self.email_address)
            time.sleep(2)
        except Exception as e:
            error_email.append(self.email_address)
            print(e)

def calc_count_time():
    endTime = datetime.now()
    diffSeconds = (endTime - startTime).seconds
    diffTime = str(diffSeconds) + "s"
    if diffSeconds >= 60 and diffSeconds < 3600:
        diffMinutes = (
            str(int(diffSeconds / 60)) + "min " + str(int(diffSeconds % 60)) + "s"
        )
        diffTime = diffMinutes
    elif diffSeconds >= 3600:
        afterSeconds = diffSeconds % 3600
        diffHours = (
            str(int(diffSeconds / 3600))
            + "h "
            + str(int(afterSeconds / 60))
            + "min "
            + str(int(afterSeconds % 60))
            + "s"
        )
        diffTime = diffHours
    print("运行时间：diffTime\t" + str(diffTime))
def read_email_action(imap_protocol, port, email_address, password):
    demo = Email_parse(imap_protocol, port, email_address, password)
    demo.gmail_read()

#  收件箱 json  日志 文件 单独
def genInboxJsonFileName():
    dirs = "./json/" + 'api_log'
    if not os.path.exists(dirs):
        os.makedirs(dirs)
    return dirs + "/" + 'verify_log' + "_inbox.json"
# 写收件箱 json日志
def write_inbox_json(data):
    with open(genInboxJsonFileName(), "w", encoding="utf-8") as file:
        # 使用 json.dump() 将字典写入文件
        json.dump(data, file, ensure_ascii=False, indent=4)

def read_sheet(data_xls,shee_name,email_list,app_code_list):
    sheet_gmail = data_xls.sheet_by_name(shee_name)  # 拿出Gmail工作表
    print(sheet_gmail)
    count_nrows = sheet_gmail.nrows  # 行数
    count_nclom = sheet_gmail.ncols  # 列数
    print(count_nclom, count_nrows)

    for i in range(3, count_nrows):  # 遍历行列 从第4行 开始
        gmail_address=sheet_gmail.cell(i, 0).value

        gmail_password=sheet_gmail.cell(i, 1).value
        email_password_store[gmail_address]=gmail_password
        gmail_code=sheet_gmail.cell(i, 2).value
        gmail_status=sheet_gmail.cell(i, 4).value
        print(gmail_address,gmail_code,gmail_status)  # 拿出数据 是否授权登录
        if gmail_status == '是':
            email_list.append(gmail_address)
            app_code_list.append(gmail_code)
            print('注册的 email',gmail_address, gmail_code, gmail_status)  # 拿出数据 是否授权登录
def read_excel_email():
    email_list=[]
    app_code_list=[]

    data_xls = xlrd.open_workbook("./Warmup预热邮箱采集-批量.xls")
    read_sheet(data_xls,'Gmail',email_list,app_code_list)
    # read_sheet(data_xls,'Outlook',email_list,app_code_list)
    read_sheet(data_xls,'QQ',email_list,app_code_list)
    read_sheet(data_xls,'163',email_list,app_code_list)
    print('email_list',email_list)

    # # 使用线程池来并发处理多个账户  50
    with ThreadPoolExecutor(max_workers=80) as executor:
        for email_address, password in zip(email_list, app_code_list):
            print(' email_address, password ', email_address, password )
            if email_address.endswith('gmail.com'):
                executor.submit(read_email_action, 'imap.gmail.com', 993, email_address, password)
            elif  email_address.endswith('qq.com'):
                executor.submit(read_email_action, 'imap.qq.com', 993, email_address, password)
            elif  email_address.endswith('163.com'):
                executor.submit(read_email_action, 'imap.163.com', 993, email_address, password)
            elif  email_address.endswith('outlook.com'):
                executor.submit(read_email_action, 'imap.outlook.com', 993, email_address, password)
            # gmail

    calc_count_time()
    # localtime
    localtime = time.localtime()
    # folder name
    folder_name = "%s_%s_%s" % (localtime.tm_year, localtime.tm_mon, localtime.tm_mday)
    global success_email
    success_email=list(set(success_email))
    global error_email
    error_email=list(set(error_email))
    write_inbox_json({
        'successEmail':success_email,
        'successEmailNum':len(success_email),
        'errorEmail': error_email,
        'errorEmailNum': len(error_email),
    })
    write_csv()

    print(error_email)


def write_csv():
    #  1.创建文件对象
    f = open('email__verify_有效20250819——1.csv', 'w', encoding='utf-8-sig', newline="")
    #  2.基于文件对象构建csv写入对象
    csv_write = csv.writer(f)
    #  3.构建列表头
    csv_write.writerow(['有效Email','密码', 'app code','是否有效'])
    for e in success_email:
        csv_write.writerow([e,email_password_store[e], email_store[e], '有效'])

    #  1.创建文件对象
    f = open('email__verify_无效20250819——1.csv', 'w', encoding='utf-8-sig', newline="")
    #  2.基于文件对象构建csv写入对象
    csv_write = csv.writer(f)
    #  3.构建列表头
    csv_write.writerow(['无效Email','密码', 'app code','是否有效'])
    for e in error_email:
        csv_write.writerow([e,email_password_store[e], email_store[e], '无效'])


    #  1.创建文件对象
    f = open('email__verify_所有20250819——1.csv', 'w', encoding='utf-8-sig', newline="")
    #  2.基于文件对象构建csv写入对象
    csv_write = csv.writer(f)
    #  3.构建列表头
    csv_write.writerow(['所有Email','密码', 'app code','是否有效'])
    for e in success_email:
        csv_write.writerow([e,email_password_store[e], email_store[e], '有效'])
    for e in error_email:
        csv_write.writerow([e, email_password_store[e],email_store[e], '无效'])
    print('所有邮箱数量：',len(success_email)+len(error_email))
    print('成功邮箱数量：',len(success_email))
    print('失败邮箱数量：',len(error_email))
    total=len(success_email)+len(error_email)
    print('无效有效占比：',len(error_email)/total)
    print('有效有效占比：',len(success_email)/total)




if __name__ == "__main__":
    startTime = datetime.now()
    success_email=[]
    error_email=[]
    email_store={}
    email_password_store={}
    threads_event=[]
    read_excel_email()

