CMAKE_MINIMUM_REQUIRED(VERSION 2.8)
PROJECT(TDengine)

IF (${ACCOUNT} MATCHES "true")
  SET(TD_ACCOUNT TRUE)
  MESSAGE(STATUS "Build with account plugins")
ELSEIF (${ACCOUNT} MATCHES "false")
  SET(TD_ACCOUNT FALSE)
  MESSAGE(STATUS "Build without account plugins")
ENDIF ()

IF (${TOPIC} MATCHES "true")
  SET(TD_TOPIC TRUE)
  MESSAGE(STATUS "Build with topic plugins")
ELSEIF (${TOPIC} MATCHES "false")
  SET(TD_TOPIC FALSE)
  MESSAGE(STATUS "Build without topic plugins")
ENDIF ()

IF (${TD_MODULE} MATCHES "true")
  SET(TD_MODULE TRUE)
  MESSAGE(STATUS "Build with module plugins")
ELSEIF (${TOPIC} MATCHES "false")
  SET(TD_MODULE FALSE)
  MESSAGE(STATUS "Build without module plugins")
ENDIF ()

IF (${COVER} MATCHES "true")
  SET(TD_COVER TRUE)
  MESSAGE(STATUS "Build with test coverage")
ELSEIF (${COVER} MATCHES "false")
  SET(TD_COVER FALSE)
  MESSAGE(STATUS "Build without test coverage")
ENDIF ()

IF (${PAGMODE} MATCHES "lite")
  SET(TD_PAGMODE_LITE TRUE)
  MESSAGE(STATUS "Build with pagmode lite")
ENDIF ()

IF (${SOMODE} MATCHES "static")
  SET(TD_SOMODE_STATIC TRUE)
  MESSAGE(STATUS "Link so using static mode")
ENDIF ()

IF (${DBNAME} MATCHES "power")
  SET(TD_POWER TRUE)
  MESSAGE(STATUS "power is true")
ENDIF ()

IF (${DLLTYPE} MATCHES "go")
  SET(TD_GODLL TRUE)
  MESSAGE(STATUS "input dll type: " ${DLLTYPE})
ENDIF ()

IF (${MEM_CHECK} MATCHES "true")
  SET(TD_MEM_CHECK TRUE)
  MESSAGE(STATUS "build with memory check")
ENDIF ()

IF (${MQTT} MATCHES "false")
  SET(TD_MQTT FALSE)
  MESSAGE(STATUS "build without mqtt module")
ENDIF ()

IF (${RANDOM_FILE_FAIL} MATCHES "true")
  SET(TD_RANDOM_FILE_FAIL TRUE)
  MESSAGE(STATUS "build with random-file-fail enabled")
ENDIF ()

IF (${RANDOM_NETWORK_FAIL} MATCHES "true")
  SET(TD_RANDOM_NETWORK_FAIL TRUE)
  MESSAGE(STATUS "build with random-network-fail enabled")
ENDIF ()

IF (${JEMALLOC_ENABLED} MATCHES "true")
  SET(TD_JEMALLOC_ENABLED TRUE)
  MESSAGE(STATUS "build with jemalloc enabled")
ENDIF ()

SET(TD_BUILD_JDBC TRUE)

IF (${BUILD_JDBC} MATCHES "false")
  SET(TD_BUILD_JDBC FALSE)
ENDIF ()

SET(TD_MEMORY_SANITIZER FALSE)
IF (${MEMORY_SANITIZER} MATCHES "true")
  SET(TD_MEMORY_SANITIZER TRUE)
ENDIF ()
