CMAKE_MINIMUM_REQUIRED(VERSION 2.8)
PROJECT(TDengine)

#
# If it is a Windows operating system
#   1.Use command line tool of VS2013 or higher version
#     mkdir build; cd build;
#     cmake -G "NMake Makefiles" ..
#     nmake install
#   2.Use the VS development interface tool
#     mkdir build; cd build;
#     cmake -A x64 ..
#     open the file named TDengine.sln
#

# Set macro definitions according to os platform
SET(TD_LINUX_64 FALSE)
SET(TD_LINUX_32 FALSE)
SET(TD_ARM FALSE)
SET(TD_ARM_64 FALSE)
SET(TD_ARM_32 FALSE)
SET(TD_MIPS FALSE)
SET(TD_MIPS_64 FALSE)
SET(TD_MIPS_32 FALSE)
SET(TD_DARWIN_64 FALSE)
SET(TD_WINDOWS_64 FALSE)

# if generate ARM version:
#   cmake -DCPUTYPE=aarch32 .. or cmake -DCPUTYPE=aarch64
IF (${CPUTYPE} MATCHES "aarch32")
  SET(TD_ARM TRUE)
  SET(TD_ARM_32 TRUE)
  SET(TD_PAGMODE_LITE TRUE)
  ADD_DEFINITIONS(-D_TD_ARM_)
  ADD_DEFINITIONS(-D_TD_ARM_32_)
ELSEIF (${CPUTYPE} MATCHES "aarch64")
  SET(TD_ARM TRUE)
  SET(TD_ARM_64 TRUE)
  ADD_DEFINITIONS(-D_TD_ARM_)
  ADD_DEFINITIONS(-D_TD_ARM_64_)
ELSEIF (${CPUTYPE} MATCHES "mips64")
  SET(TD_MIPS TRUE)
  SET(TD_MIPS_64 TRUE)
  ADD_DEFINITIONS(-D_TD_MIPS_)
  ADD_DEFINITIONS(-D_TD_MIPS_64_)
ELSEIF (${CPUTYPE} MATCHES "x64")
  MESSAGE(STATUS "input cpuType: " ${CPUTYPE})
ELSEIF (${CPUTYPE} MATCHES "x86")
  MESSAGE(STATUS "input cpuType: " ${CPUTYPE})
ELSE ()
  MESSAGE(STATUS "input cpuType: " ${CPUTYPE})
ENDIF ()

#
# Get OS information and store in variable TD_OS_INFO.
#
execute_process(COMMAND chmod 777 ${TD_COMMUNITY_DIR}/packaging/tools/get_os.sh)
execute_process(COMMAND ${TD_COMMUNITY_DIR}/packaging/tools/get_os.sh "" OUTPUT_VARIABLE TD_OS_INFO)
MESSAGE(STATUS "The current os is " ${TD_OS_INFO})

IF (${CMAKE_SYSTEM_NAME} MATCHES "Linux")
  IF (${CMAKE_SIZEOF_VOID_P} MATCHES 8)
    SET(TD_LINUX_64 TRUE)
    SET(TD_OS_DIR ${TD_COMMUNITY_DIR}/src/os/linux)
    ADD_DEFINITIONS(-D_M_X64)
    MESSAGE(STATUS "The current platform is Linux 64-bit")
  ELSEIF (${CMAKE_SIZEOF_VOID_P} MATCHES 4)
    IF (TD_ARM)
      SET(TD_LINUX_32 TRUE)
      SET(TD_OS_DIR ${TD_COMMUNITY_DIR}/src/os/linux)
      #ADD_DEFINITIONS(-D_M_IX86)
      MESSAGE(STATUS "The current platform is Linux 32-bit")
    ELSE ()
      MESSAGE(FATAL_ERROR "The current platform is Linux 32-bit, but no ARM not supported yet")
      EXIT ()
    ENDIF ()
  ELSE ()
    MESSAGE(FATAL_ERROR "The current platform is Linux neither 32-bit nor 64-bit, not supported yet")
    EXIT ()
  ENDIF ()
ELSEIF (${CMAKE_SYSTEM_NAME} MATCHES "Darwin")
  IF (${CMAKE_SIZEOF_VOID_P} MATCHES 8)
    SET(TD_DARWIN_64 TRUE)
    SET(TD_OS_DIR ${TD_COMMUNITY_DIR}/src/os/darwin)
    MESSAGE(STATUS "The current platform is Darwin 64-bit")
  ELSE ()
    MESSAGE(FATAL_ERROR "The current platform is Darwin 32-bit, not supported yet")
    EXIT ()
  ENDIF ()
ELSEIF (${CMAKE_SYSTEM_NAME} MATCHES "Windows")
  IF (${CMAKE_SIZEOF_VOID_P} MATCHES 8)
    SET(TD_WINDOWS_64 TRUE)
    SET(TD_OS_DIR ${TD_COMMUNITY_DIR}/src/os/windows)
    ADD_DEFINITIONS(-D_M_X64)
    MESSAGE(STATUS "The current platform is Windows 64-bit")
  ELSE ()
    MESSAGE(FATAL_ERROR "The current platform is Windows 32-bit, not supported yet")
    EXIT ()
  ENDIF ()
ELSE()
  MESSAGE(FATAL_ERROR "The current platform is not Linux/Darwin/Windows, stop compile")
  EXIT ()
ENDIF ()

IF (TD_LINUX_64)
    SET(DEBUG_FLAGS "-O0 -DDEBUG")
    SET(RELEASE_FLAGS "-O0")
    IF (NOT TD_ARM)
      IF (${CMAKE_CXX_COMPILER_ID} MATCHES "Clang")
        SET(COMMON_FLAGS "-std=gnu99 -Wall -fPIC -malign-double -g3 -gdwarf-2 -msse4.2 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
      ELSE ()
        SET(COMMON_FLAGS "-std=gnu99 -Wall -fPIC -malign-double -g3 -gdwarf-2 -malign-stringops -msse4.2 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
      ENDIF ()
    ELSE ()
      SET(COMMON_FLAGS "-std=gnu99 -Wall -fPIC -g -fsigned-char -fpack-struct=8 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
    ENDIF ()
    ADD_DEFINITIONS(-DLINUX)
    ADD_DEFINITIONS(-D_REENTRANT -D__USE_POSIX -D_LIBC_REENTRANT)
    IF (${TD_OS_INFO} MATCHES "Alpine")
      MESSAGE(STATUS "The current OS is Alpine, append extra flags")
      SET(COMMON_FLAGS "${COMMON_FLAGS} -largp")
      link_libraries(/usr/lib/libargp.a)
      ADD_DEFINITIONS(-D_ALPINE)
    ENDIF ()
  ELSEIF (TD_LINUX_32)
    IF (NOT TD_ARM)
      EXIT ()
    ENDIF ()
    SET(DEBUG_FLAGS "-O0 -DDEBUG")
    SET(RELEASE_FLAGS "-O0")
    SET(COMMON_FLAGS "-std=gnu99 -Wall -fPIC -g -fsigned-char -munaligned-access -fpack-struct=8 -latomic -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
    ADD_DEFINITIONS(-DLINUX)
    ADD_DEFINITIONS(-D_REENTRANT -D__USE_POSIX -D_LIBC_REENTRANT)
    ADD_DEFINITIONS(-DUSE_LIBICONV)
    IF (${TD_OS_INFO} MATCHES "Alpine")
      MESSAGE(STATUS "The current OS is Alpine, add extra flags")
      SET(COMMON_FLAGS "${COMMON_FLAGS} -largp")
      link_library(/usr/lib/libargp.a)
      ADD_DEFINITIONS(-D_ALPINE)
    ENDIF ()
  ELSEIF (TD_WINDOWS_64)
    SET(CMAKE_GENERATOR "NMake Makefiles" CACHE INTERNAL "" FORCE)
    IF (NOT TD_GODLL)
      SET(COMMON_FLAGS "/nologo /WX- /Oi /Oy- /Gm- /EHsc /MT /GS /Gy /fp:precise /Zc:wchar_t /Zc:forScope /Gd /errorReport:prompt /analyze-")
      SET(DEBUG_FLAGS "/Zi /W3 /GL")
      SET(RELEASE_FLAGS "/W0 /GL")
    ENDIF ()
    ADD_DEFINITIONS(-DWINDOWS)
    ADD_DEFINITIONS(-D__CLEANUP_C)
    ADD_DEFINITIONS(-DPTW32_STATIC_LIB)
    ADD_DEFINITIONS(-DPTW32_BUILD)
    ADD_DEFINITIONS(-D_MBCS -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE)
  ELSEIF (TD_DARWIN_64)
    SET(COMMON_FLAGS "-std=gnu99 -Wall -fPIC -malign-double -g -msse4.2 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
    SET(DEBUG_FLAGS "-O0 -DDEBUG")
    SET(RELEASE_FLAGS "-O0")
    ADD_DEFINITIONS(-DDARWIN)
    ADD_DEFINITIONS(-D_REENTRANT -D__USE_POSIX -D_LIBC_REENTRANT)
  ELSE ()
    MESSAGE(FATAL_ERROR "The current platform is not support yet, stop compile")
    EXIT ()
  ENDIF ()