/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBDatabaseMetaData;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBPreparedStatement;
import com.taosdata.jdbc.TSDBStatement;
import com.taosdata.jdbc.TSDBSubscribe;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class TSDBConnection
implements Connection {
    protected Properties props = null;
    private TSDBJNIConnector connector = null;
    private String catalog = null;
    private TSDBDatabaseMetaData dbMetaData = null;
    private Properties clientInfoProps = new Properties();
    private int timeoutMilliseconds = 0;
    private boolean batchFetch = false;

    public TSDBConnection(Properties info, TSDBDatabaseMetaData meta) throws SQLException {
        this.dbMetaData = meta;
        this.connect(info.getProperty("host"), Integer.parseInt(info.getProperty("port", "0")), info.getProperty("dbname"), info.getProperty("user"), info.getProperty("password"));
        String batchLoad = info.getProperty("batchfetch");
        if (batchLoad != null) {
            this.batchFetch = Boolean.parseBoolean(batchLoad);
        }
    }

    private void connect(String host, int port, String dbName, String user, String password) throws SQLException {
        this.connector = new TSDBJNIConnector();
        this.connector.connect(host, port, dbName, user, password);
        try {
            this.setCatalog(dbName);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dbMetaData.setConnection(this);
    }

    public TSDBJNIConnector getConnection() {
        return this.connector;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (!this.connector.isClosed()) {
            TSDBStatement statement = new TSDBStatement(this, this.connector);
            statement.setConnection(this);
            return statement;
        }
        throw new SQLException(TSDBConstants.FixErrMsg(-2));
    }

    public TSDBSubscribe subscribe(String topic, String sql, boolean restart) throws SQLException {
        if (this.connector.isClosed()) {
            throw new SQLException(TSDBConstants.FixErrMsg(-2));
        }
        long id = this.connector.subscribe(topic, sql, restart, 0);
        if (id == 0L) {
            throw new SQLException(TSDBConstants.WrapErrMsg("failed to create subscription"));
        }
        return new TSDBSubscribe(this.connector, id);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (!this.connector.isClosed()) {
            return new TSDBPreparedStatement(this, this.connector, sql);
        }
        throw new SQLException(TSDBConstants.FixErrMsg(-2));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void close() throws SQLException {
        if (this.connector == null || this.connector.isClosed()) {
            throw new SQLException(TSDBConstants.WrapErrMsg("connection is already closed!"));
        }
        this.connector.closeConnection();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connector.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.dbMetaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.catalog = catalog;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003) {
            throw new SQLException("invalid variables");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLException("invalid variables");
        }
        return this.prepareStatement(sql);
    }

    public Boolean getBatchFetch() {
        return this.batchFetch;
    }

    public void setBatchFetch(Boolean batchFetch) {
        this.batchFetch = batchFetch;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return !this.isClosed();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfoProps.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Enumeration<Object> enumer = properties.keys();
        while (enumer.hasMoreElements()) {
            String name = (String)enumer.nextElement();
            this.clientInfoProps.put(name, properties.getProperty(name));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfoProps.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfoProps;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.timeoutMilliseconds = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.timeoutMilliseconds;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }
}

