/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBConstants;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class TSDBResultSetMetaData
implements ResultSetMetaData {
    List<ColumnMetaData> colMetaDataList = null;

    public TSDBResultSetMetaData(List<ColumnMetaData> metaDataList) {
        this.colMetaDataList = metaDataList;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.colMetaDataList.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return column == 1;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        if (column == 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        ColumnMetaData meta = this.colMetaDataList.get(column - 1);
        switch (meta.getColType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.colMetaDataList.get(column - 1).getColSize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.colMetaDataList.get(column - 1).getColName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.colMetaDataList.get(column - 1).getColName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        ColumnMetaData columnMetaData = this.colMetaDataList.get(column - 1);
        switch (columnMetaData.getColType()) {
            case 6: {
                return 5;
            }
            case 7: {
                return 9;
            }
            case 8: 
            case 10: {
                return columnMetaData.getColSize();
            }
        }
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        ColumnMetaData meta = this.colMetaDataList.get(column - 1);
        switch (meta.getColType()) {
            case 6: {
                return 5;
            }
            case 7: {
                return 9;
            }
        }
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnMetaData meta = this.colMetaDataList.get(column - 1);
        switch (meta.getColType()) {
            case 1: {
                return -7;
            }
            case 2: {
                return -6;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return -5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return -5;
            }
            case 10: {
                return 1;
            }
        }
        throw new SQLException("invalid variables");
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnMetaData meta = this.colMetaDataList.get(column - 1);
        return TSDBConstants.DATATYPE_MAP.get(meta.getColType());
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        String columnClassName = "";
        switch (columnType) {
            case 93: {
                columnClassName = Timestamp.class.getName();
                break;
            }
            case 1: {
                columnClassName = String.class.getName();
                break;
            }
            case 8: {
                columnClassName = Double.class.getName();
                break;
            }
            case 6: {
                columnClassName = Float.class.getName();
                break;
            }
            case -5: {
                columnClassName = Long.class.getName();
                break;
            }
            case 4: {
                columnClassName = Integer.class.getName();
                break;
            }
            case 5: {
                columnClassName = Short.class.getName();
                break;
            }
            case -6: {
                columnClassName = Byte.class.getName();
                break;
            }
            case -7: {
                columnClassName = Boolean.class.getName();
            }
        }
        return columnClassName;
    }
}

