/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSetBlockData;
import com.taosdata.jdbc.TSDBResultSetMetaData;
import com.taosdata.jdbc.TSDBResultSetRowData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class TSDBResultSet
implements ResultSet {
    private TSDBJNIConnector jniConnector = null;
    private long resultSetPointer = 0L;
    private List<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>();
    private TSDBResultSetRowData rowData;
    private TSDBResultSetBlockData blockData;
    private boolean batchFetch = false;
    private boolean lastWasNull = false;
    private final int COLUMN_INDEX_START_VALUE = 1;
    private int rowIndex = 0;

    public TSDBJNIConnector getJniConnector() {
        return this.jniConnector;
    }

    public void setJniConnector(TSDBJNIConnector jniConnector) {
        this.jniConnector = jniConnector;
    }

    public long getResultSetPointer() {
        return this.resultSetPointer;
    }

    public void setResultSetPointer(long resultSetPointer) {
        this.resultSetPointer = resultSetPointer;
    }

    public void setBatchFetch(boolean batchFetch) {
        this.batchFetch = batchFetch;
    }

    public Boolean getBatchFetch() {
        return this.batchFetch;
    }

    public List<ColumnMetaData> getColumnMetaDataList() {
        return this.columnMetaDataList;
    }

    public void setColumnMetaDataList(List<ColumnMetaData> columnMetaDataList) {
        this.columnMetaDataList = columnMetaDataList;
    }

    public TSDBResultSetRowData getRowData() {
        return this.rowData;
    }

    public void setRowData(TSDBResultSetRowData rowData) {
        this.rowData = rowData;
    }

    public boolean isLastWasNull() {
        return this.lastWasNull;
    }

    public void setLastWasNull(boolean lastWasNull) {
        this.lastWasNull = lastWasNull;
    }

    public TSDBResultSet() {
    }

    public TSDBResultSet(TSDBJNIConnector connector, long resultSetPointer) throws SQLException {
        this.jniConnector = connector;
        this.resultSetPointer = resultSetPointer;
        int code = this.jniConnector.getSchemaMetaData(this.resultSetPointer, this.columnMetaDataList);
        if (code == -2) {
            throw new SQLException(TSDBConstants.FixErrMsg(-2));
        }
        if (code == -3) {
            throw new SQLException(TSDBConstants.FixErrMsg(-3));
        }
        if (code == -4) {
            throw new SQLException(TSDBConstants.FixErrMsg(-4));
        }
        this.rowData = new TSDBResultSetRowData(this.columnMetaDataList.size());
        this.blockData = new TSDBResultSetBlockData(this.columnMetaDataList, this.columnMetaDataList.size());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean next() throws SQLException {
        int code;
        if (this.getBatchFetch().booleanValue()) {
            if (this.blockData.forward()) {
                return true;
            }
            int code2 = this.jniConnector.fetchBlock(this.resultSetPointer, this.blockData);
            this.blockData.reset();
            if (code2 == -2) {
                throw new SQLException(TSDBConstants.FixErrMsg(-2));
            }
            if (code2 == -3) {
                throw new SQLException(TSDBConstants.FixErrMsg(-3));
            }
            if (code2 == -4) {
                throw new SQLException(TSDBConstants.FixErrMsg(-4));
            }
            return code2 != -6;
        }
        if (this.rowData != null) {
            this.rowData.clear();
        }
        if ((code = this.jniConnector.fetchRow(this.resultSetPointer, this.rowData)) == -2) {
            throw new SQLException(TSDBConstants.FixErrMsg(-2));
        }
        if (code == -3) {
            throw new SQLException(TSDBConstants.FixErrMsg(-3));
        }
        if (code == -4) {
            throw new SQLException(TSDBConstants.FixErrMsg(-4));
        }
        return code != -6;
    }

    @Override
    public void close() throws SQLException {
        if (this.jniConnector != null) {
            int code = this.jniConnector.freeResultSet(this.resultSetPointer);
            if (code == -2) {
                throw new SQLException(TSDBConstants.FixErrMsg(-2));
            }
            if (code == -3) {
                throw new SQLException(TSDBConstants.FixErrMsg(-3));
            }
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastWasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        String res = null;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = this.rowData.getString(colIndex, this.columnMetaDataList.get(colIndex).getColType());
            }
            return res;
        }
        return this.blockData.getString(colIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        boolean res = false;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = this.rowData.getBoolean(colIndex, this.columnMetaDataList.get(colIndex).getColType());
            }
        } else {
            return this.blockData.getBoolean(colIndex);
        }
        return res;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        byte res = 0;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = (byte)this.rowData.getInt(colIndex, this.columnMetaDataList.get(colIndex).getColType());
            }
            return res;
        }
        return (byte)this.blockData.getInt(colIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        short res = 0;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = (short)this.rowData.getInt(colIndex, this.columnMetaDataList.get(colIndex).getColType());
            }
            return res;
        }
        return (short)this.blockData.getInt(colIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        int res = 0;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = this.rowData.getInt(colIndex, this.columnMetaDataList.get(colIndex).getColType());
            }
            return res;
        }
        return this.blockData.getInt(colIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        long res = 0L;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = this.rowData.getLong(colIndex, this.columnMetaDataList.get(colIndex).getColType());
            }
            return res;
        }
        return this.blockData.getLong(colIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        float res = 0.0f;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = this.rowData.getFloat(colIndex, this.columnMetaDataList.get(colIndex).getColType());
            }
            return res;
        }
        return (float)this.blockData.getDouble(colIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        double res = 0.0;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = this.rowData.getDouble(colIndex, this.columnMetaDataList.get(colIndex).getColType());
            }
            return res;
        }
        return this.blockData.getDouble(colIndex);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return new BigDecimal(this.getLong(columnIndex));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getString(columnIndex).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        int colIndex = this.getTrueColumnIndex(columnIndex);
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        int colIndex = this.getTrueColumnIndex(columnIndex);
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Timestamp res = null;
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            if (!this.lastWasNull) {
                res = this.rowData.getTimestamp(colIndex);
            }
            return res;
        }
        return this.blockData.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new TSDBResultSetMetaData(this.columnMetaDataList);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            return this.rowData.get(colIndex);
        }
        return this.blockData.get(colIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        for (ColumnMetaData colMetaData : this.columnMetaDataList) {
            if (colMetaData.getColName() == null || !colMetaData.getColName().equalsIgnoreCase(columnLabel)) continue;
            return colMetaData.getColIndex() + 1;
        }
        throw new SQLException("invalid variables");
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        int colIndex = this.getTrueColumnIndex(columnIndex);
        if (!this.getBatchFetch().booleanValue()) {
            this.lastWasNull = this.rowData.wasNull(colIndex);
            return new BigDecimal(this.rowData.getLong(colIndex, this.columnMetaDataList.get(colIndex).getColType()));
        }
        return new BigDecimal(this.blockData.getLong(colIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean isClosed = true;
        if (this.jniConnector != null) {
            isClosed = this.jniConnector.isResultsetClosed();
        }
        return isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        int colIndex = this.getTrueColumnIndex(columnIndex);
        return (String)this.rowData.get(colIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLException("this operation is NOT supported currently!");
    }

    private int getTrueColumnIndex(int columnIndex) throws SQLException {
        if (columnIndex < this.COLUMN_INDEX_START_VALUE) {
            throw new SQLException("Column Index out of range, " + columnIndex + " < " + this.COLUMN_INDEX_START_VALUE);
        }
        int numOfCols = this.columnMetaDataList.size();
        if (columnIndex > numOfCols) {
            throw new SQLException("Column Index out of range, " + columnIndex + " > " + numOfCols);
        }
        return columnIndex - 1;
    }
}

