PR['registerLangHandler'](
  PR['createSimpleLexer'](
    [
      // Whitespace
      [PR['PR_PLAIN'], /^[\t\n\r \xA0]+/, null, '\t\n\r \xA0'],
      // A double or single quoted, possibly multi-line, string.
      [PR['PR_STRING'], /^(?:"(?:[^\"\\]|\\.)*"|'(?:[^\'\\]|\\.)*')/, null,
      '"\'']
    ],
    [
      // A comment is either a line comment that starts with two dashes, or
      // two dashes preceding a long bracketed block.
      [PR['PR_COMMENT'], /^(?:--[^\r\n]*|\/\*[\s\S]*?(?:\*\/|$))/],
      [PR['PR_KEYWORD'], /^(?:ADD|ALL|ALTER|AND|ANY|APPLY|AS|ASC|AUTHORIZATION|BACKUP|BEGIN|BETWEEN|BREAK|BROWSE|BULK|BY|CASCADE|CASE|CHECK|CHECKPOINT|CLOSE|CLUSTERED|COALESCE|COLLATE|COLUMN|COMMIT|COMPUTE|CONNECT|CONSTRAINT|CONTAINS|CONTAINSTABLE|CONTINUE|CONVERT|CREATE|CROSS|CURRENT|CURRENT_DATE|CURRENT_TIME|CURRENT_TIMESTAMP|CURRENT_USER|CURSOR|DATABASE|DBCC|DEALLOCATE|DECLARE|DEFAULT|DELETE|DENY|DESC|DISK|DISTINCT|DISTRIBUTED|DROP|DUMMY|DUMP|ELSE|END|ERRLVL|ESCAPE|EXCEPT|EXEC|EXECUTE|EXISTS|EXIT|FETCH|FILE|FILL|FILLFACTOR|FOLLOWING|FOR|FOREIGN|FREETEXT|FREETEXTTABLE|FROM|FULL|FUNCTION|GOTO|GRANT|GROUP|HAVING|HOLDLOCK|IDENTITY|IDENTITYCOL|IDENTITY_INSERT|IF|IN|INDEX|INNER|INSERT|INTERSECT|INTO|IS|JOIN|KEY|KILL|LEFT|LIKE|LINENO|LOAD|MATCH|MATCHED|MERGE|NATURAL|NATIONAL|NOCHECK|NONCLUSTERED|NOCYCLE|NOT|NULL|NULLIF|OF|OFF|OFFSETS|ON|OPEN|OPENDATASOURCE|OPENQUERY|OPENROWSET|OPENXML|OPTION|OR|ORDER|OUTER|OVER|PARTITION|PERCENT|PIVOT|PLAN|PRECEDING|PRIMARY|PRINT|PROC|PROCEDURE|PUBLIC|RAISERROR|READ|READTEXT|RECONFIGURE|REFERENCES|REPLICATION|RESTORE|RESTRICT|RETURN|REVOKE|RIGHT|ROLLBACK|ROWCOUNT|ROWGUIDCOL|RULE|SAVE|SCHEMA|SELECT|SESSION_USER|SET|SETUSER|SHUTDOWN|SLIDING|SOME|START|STATISTICS|SYSTEM_USER|TABLE|TAGS|TEXTSIZE|THEN|TO|TRAN|TRANSACTION|TRIGGER|TRUNCATE|TSEQUAL|UNBOUNDED|UNION|UNIQUE|UNPIVOT|UPDATE|UPDATETEXT|USE|USER|USING|VALUES|VARYING|VIEW|WAITFOR|WHEN|WHERE|WHILE|WITH|WITHIN|WRITETEXT|XML|ID|STRING|INTEGER|OR|AND|NOT|EQ|NE|ISNULL|NOTNULL|IS|LIKE|GLOB|BETWEEN|IN|GT|GE|LT|LE|BITAND|BITOR|LSHIFT|RSHIFT|PLUS|MINUS|DIVIDE|TIMES|STAR|SLASH|REM|CONCAT|UMINUS|UPLUS|BITNOT|SHOW|DATABASES|MNODES|USERS|MODULES|QUERIES|CONNECTIONS|STREAMS|CONFIGS|SCORES|GRANTS|DOT|TABLES|METRICS|VGROUPS|DROP|TABLE|DATABASE|IP|USER|USE|DESCRIBE|ALTER|PASS|PRIVILEGE|LOCAL|IF|EXISTS|REPLICA|DAYS|KEEP|ROWS|CACHE|ABLOCKS|TBLOCKS|CTIME|CLOG|COMP|LP|RP|TAGS|USING|AS|COMMA|SELECT|FROM|VARIABLE|INTERVAL|FILL|SLIDING|ORDER|BY|ASC|DESC|GROUP|LIMIT|OFFSET|WHERE|NOW|INSERT|INTO|VALUES|RESET|QUERY|ADD|COLUMN|TAG|CHANGE|SET|KILL|CONNECTION|STREAM|ABORT|AFTER|ATTACH|BEFORE|BEGIN|CASCADE|CLUSTER|CONFLICT|COPY|DEFERRED|DELIMITERS|DETACH|EACH|END|EXPLAIN|FAIL|FOR|IGNORE|IMMEDIATE|INITIALLY|INSTEAD|MATCH|KEY|OF|RAISE|REPLACE|RESTRICT|ROW|STATEMENT|TRIGGER|VIEW|ALL|SEMI|NONE|PREV|LINEAR|IMPORT|METRIC|TBNAME|JOIN|STABLE|STABLES|SLIMIT|SOFFSET|HAVING|PRECISION|STREAMS|NULL)(?=[^\w-]|$)/i, null],
      //
      [PR['TAOSDATA_FUNCTION'], /^(?:"APERCENTILE|AVG|BOTTOM|COUNT|DIFF|FIRST|HISTOGRAM|INTERP|LAST|LAST_ROW|LEASTSQUARES|MAX|MIN|PERCENTILE|SPREAD|STDDEV|SUM|TOP|WAVG")(?=[^\w-]|$)/i, null],
      [PR['TAOSDATA_OPTION'],
      /^(?:ABLOCKS|CACHE|CLOG|COMP|CTIME|DAYS|KEEP|PRECISION|REPLICA|ROWS|TABLES|TBLOCKS)(?=[^\w-]|$)/i,null],
      [PR['TAOSDATA_DATATYPE'],
      /^(?:BIGINT|BINARY|BOOL|DOUBLE|FLOAT|INT|NCHAR|SMALLINT|TINYINT[^\w-]|$)/i, null],
      // A number is a hex integer literal, a decimal real literal, or in
      // scientific notation.
      [PR['PR_LITERAL'],
      /^[+-]?(?:0x[\da-f]+|(?:(?:\.\d+|\d+(?:\.\d*)?)(?:e[+\-]?\d+)?))/i],
      // An identifier
      [PR['PR_PLAIN'], /^[a-z_][\w-]*/i],
      // A run of punctuation
      [PR['PR_PUNCTUATION'], /^[^\w\t\n\r \xA0\"\'][^\w\t\n\r \xA0+\-\"\']*/]
    ]
  ),
['sql','mysql']);