/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBResultSet;
import java.sql.SQLException;
import javax.management.OperationsException;

public class TSDBSubscribe {
    private TSDBJNIConnector connecter = null;
    private long id = 0L;

    TSDBSubscribe(TSDBJNIConnector connecter, long id) throws SQLException {
        if (null == connecter) {
            throw new SQLException(TSDBConstants.FixErrMsg(-2));
        }
        this.connecter = connecter;
        this.id = id;
    }

    public TSDBResultSet consume() throws OperationsException, SQLException {
        if (this.connecter.isClosed()) {
            throw new SQLException(TSDBConstants.FixErrMsg(-2));
        }
        long resultSetPointer = this.connecter.consume(this.id);
        if (resultSetPointer == -2L) {
            throw new SQLException(TSDBConstants.FixErrMsg(-2));
        }
        if (resultSetPointer == 0L) {
            return null;
        }
        return new TSDBResultSet(this.connecter, resultSetPointer);
    }

    public void close(boolean keepProgress) throws SQLException {
        if (this.connecter.isClosed()) {
            throw new SQLException(TSDBConstants.FixErrMsg(-2));
        }
        this.connecter.unsubscribe(this.id, keepProgress);
    }
}

