/*
 * Copyright (c) 2019 TAOS Data, Inc. <jhtao@taosdata.com>
 *
 * This program is free software: you can use, redistribute, and/or modify
 * it under the terms of the GNU Affero General Public License, version 3
 * or later ("AGPL"), as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "tdisk.h"

SDisk *tdNewDisk(SDiskID did, char *dir) {
  SDisk *pDisk = (SDisk *)calloc(1, sizeof(*pDisk));
  if (pDisk == NULL) {
    terrno = TSDB_CODE_FS_OUT_OF_MEMORY;
    return NULL;
  }

  pDisk->level = did.level;
  pDisk->id = did.id;
  strncpy(pDisk->dir, dir, TSDB_FILENAME_LEN);

  return pDisk;
}

void tdFreeDisk(SDisk *pDisk) {
  if (pDisk) {
    free(pDisk)
  }
}