/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class AbstractTaosDriver
implements Driver {
    private static final String TAOS_CFG_FILENAME = "taos.cfg";

    protected File loadConfigDir(String cfgDirPath) {
        if (cfgDirPath == null) {
            return this.loadDefaultConfigDir();
        }
        File cfgDir = new File(cfgDirPath);
        if (!cfgDir.exists()) {
            return this.loadDefaultConfigDir();
        }
        return cfgDir;
    }

    protected File loadDefaultConfigDir() {
        File cfgDir_linux = new File("/etc/taos");
        File cfgDir = cfgDir_linux.exists() ? cfgDir_linux : null;
        File cfgDir_windows = new File("C:\\TDengine\\cfg");
        cfgDir = cfgDir == null && cfgDir_windows.exists() ? cfgDir_windows : cfgDir;
        return cfgDir;
    }

    protected List<String> loadConfigEndpoints(File cfgFile) {
        ArrayList<String> endpoints = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(cfgFile));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("firstEp") || line.trim().startsWith("secondEp")) {
                    endpoints.add(line.substring(line.indexOf(112) + 1).trim());
                }
                if (endpoints.size() <= 1) continue;
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return endpoints;
    }

    protected void loadTaosConfig(Properties info) {
        File cfgDir;
        File cfgFile;
        List<String> endpoints;
        if (!(info.getProperty("host") != null && !info.getProperty("host").isEmpty() || info.getProperty("port") != null && !info.getProperty("port").isEmpty() || (endpoints = this.loadConfigEndpoints(cfgFile = (cfgDir = this.loadConfigDir(info.getProperty("cfgdir"))).listFiles((dir, name) -> TAOS_CFG_FILENAME.equalsIgnoreCase(name))[0])).isEmpty())) {
            info.setProperty("host", endpoints.get(0).split(":")[0]);
            info.setProperty("port", endpoints.get(0).split(":")[1]);
        }
    }

    protected DriverPropertyInfo[] getPropertyInfo(Properties info) {
        DriverPropertyInfo hostProp = new DriverPropertyInfo("host", info.getProperty("host"));
        hostProp.required = false;
        hostProp.description = "Hostname";
        DriverPropertyInfo portProp = new DriverPropertyInfo("port", info.getProperty("port", "6200"));
        portProp.required = false;
        portProp.description = "Port";
        DriverPropertyInfo dbProp = new DriverPropertyInfo("dbname", info.getProperty("dbname"));
        dbProp.required = false;
        dbProp.description = "Database name";
        DriverPropertyInfo userProp = new DriverPropertyInfo("user", info.getProperty("user"));
        userProp.required = true;
        userProp.description = "User";
        DriverPropertyInfo passwordProp = new DriverPropertyInfo("password", info.getProperty("password"));
        passwordProp.required = true;
        passwordProp.description = "Password";
        DriverPropertyInfo[] propertyInfo = new DriverPropertyInfo[]{hostProp, portProp, dbProp, userProp, passwordProp};
        return propertyInfo;
    }

    protected Properties parseURL(String url, Properties defaults) {
        int indexOfColon;
        Properties urlProps = defaults != null ? defaults : new Properties();
        int beginningOfSlashes = url.indexOf("//");
        int index = url.indexOf("?");
        if (index != -1) {
            String paramString = url.substring(index + 1, url.length());
            url = url.substring(0, index);
            StringTokenizer queryParams = new StringTokenizer(paramString, "&");
            while (queryParams.hasMoreElements()) {
                String parameterValuePair = queryParams.nextToken();
                int indexOfEqual = parameterValuePair.indexOf("=");
                String parameter = null;
                String value = null;
                if (indexOfEqual != -1) {
                    parameter = parameterValuePair.substring(0, indexOfEqual);
                    if (indexOfEqual + 1 < parameterValuePair.length()) {
                        value = parameterValuePair.substring(indexOfEqual + 1);
                    }
                }
                if (value == null || value.length() <= 0 || parameter == null || parameter.length() <= 0) continue;
                urlProps.setProperty(parameter, value);
            }
        }
        String dbProductName = url.substring(0, beginningOfSlashes);
        dbProductName = dbProductName.substring(dbProductName.indexOf(":") + 1);
        dbProductName = dbProductName.substring(0, dbProductName.indexOf(":"));
        int indexOfSlash = (url = url.substring(beginningOfSlashes + 2)).indexOf("/");
        if (indexOfSlash != -1) {
            if (indexOfSlash + 1 < url.length()) {
                urlProps.setProperty("dbname", url.substring(indexOfSlash + 1));
            }
            url = url.substring(0, indexOfSlash);
        }
        if ((indexOfColon = url.indexOf(":")) != -1) {
            if (indexOfColon + 1 < url.length()) {
                urlProps.setProperty("port", url.substring(indexOfColon + 1));
            }
            url = url.substring(0, indexOfColon);
        }
        if (url != null && url.length() > 0 && url.trim().length() > 0) {
            urlProps.setProperty("host", url);
        }
        return urlProps;
    }
}

