// Copyright 2020 The MACE Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "macemc/rpc/stub/macemc.h"
#include "codegen/macemc.h"

namespace micro {
namespace testing {

namespace {
const char kMaceMcUri[] = macemc_URI"&_dom=sdsp";
}  // namespace

MaceMc::MaceMc() :
    rpc::stub::BaseHandle(macemc_open, macemc_close, kMaceMcUri) {}

void MaceMc::Run() {
  macemc_run(remote_handle_);
}

}  // namespace testing
}  // namespace micro

void MaceMcBaselineRun() {
  micro::testing::MaceMc mace_mc;
  mace_mc.Open();
  mace_mc.Run();
  mace_mc.Close();
}
