//
// Copyright (c) 2017 XiaoMi All rights reserved.
//

#include "mace/ops/matmul.h"

namespace mace {
namespace ops {

void Register_MatMul(OperatorRegistry *op_registry) {
  REGISTER_OPERATOR(op_registry, OpKeyBuilder("MatMul")
                                     .Device(DeviceType::CPU)
                                     .TypeConstraint<float>("T")
                                     .Build(),
                    MatMulOp<DeviceType::CPU, float>);

  REGISTER_OPERATOR(op_registry, OpKeyBuilder("MatMul")
                                     .Device(DeviceType::OPENCL)
                                     .TypeConstraint<float>("T")
                                     .Build(),
                    MatMulOp<DeviceType::OPENCL, float>);

  REGISTER_OPERATOR(op_registry, OpKeyBuilder("MatMul")
                                     .Device(DeviceType::OPENCL)
                                     .TypeConstraint<half>("T")
                                     .Build(),
                    MatMulOp<DeviceType::OPENCL, half>);
}

}  // namespace ops
}  // namespace mace
