import request from '../axios'// 引入封装好的axios请求对象
//节流
// 创建一个立即执行函数，利用闭包来保存已经请求过的接口地址
let myRequest = (function () {
    //通过这种闭包的写法，这个hasRequest 就不会被内存回收
    let hasRequest = [] //这样可以利用缓存来记录我们请求了哪些接口
    //一但有请求就会记录这个数组里面
    return function (config) {
        let url = config.url
        //每次发请求之前先判断一下，这个数组里面是不是已经存在本次要请求的url了
        if (hasRequest.indexOf(url) !== -1) {//传过来的配置文件里是不是已经存在了这个数组里面
            //判断一下数组里面是不是已经请求了这个地址，如果这个判断不等-1就说明存在了
            return Promise.reject({ meg: '请求已提交' })
        }
        //如果不存的话，然后发送请求，请求之前先把这个地址存到这个数组里
        hasRequest.push(url)
        return request({ //然后使用request去发送请求，然后吧config直接在这个里面展开
            ...config
        }).then((res) => {//请求成功后，我们把这个url从这个数组里删掉
            hasRequest = hasRequest.filter((item => {
                if (item !== url) {//使用filter进行删除，如果不等于请求成功的这个地址就可以不用删除
                    return item
                }
            }))
            return res
        })
    }
})()

// 将myRequest导出为request，并将原始的request对象导出为initRequest
export {
    myRequest as request,// 使用myRequest作为默认的request请求函数
    request as initRequest// 将原始的request对象导出为initRequest
}