// 导入 './request' 模块中的 'request' 函数
import { request } from './request'
// 定义一个名为 'LoginAPI' 的函数，使用箭头函数语法
export const LoginAPI = () => {
    // 在 'LoginAPI' 函数内部，返回一个对象
    return {
        // 在返回的对象内部，使用箭头函数语法定义一个名为 'login' 的方法
        login: (data) => {
            // 在 'login' 方法内部，调用 'request' 函数
            // 将包含 method、url 和 data 属性的对象作为参数传递给 'request' 函数
            return request({
                // 将 HTTP 方法指定为 'post'
                method: "post",
                // 将端点 URL 指定为 '/userLogin'
                url: "/userLogin",
                // 将 'data' 参数传递以随请求发送
                data
            })
        }
    }
}