//  配置全局的基础配置
import axios from 'axios'  //导入axios库，用于发送HTTP请求

//配置中心
import WEBconfig from './global.config'

// 导入 vue-router 库，用于路由跳转
import { useRouter } from 'vue-router'
let router = useRouter()

import md5 from 'js-md5'

//通过axios.create去创建一个axios的对象，使用来对项目发请求的一个对象。
//后面的请求通过使用request来发送请求
let request = axios.create({
    //1、配置
    baseURL: 'http://localhost:3000/',// 基础 URL 地址
    timeout: 30 * 1000,//设置超时时间为30秒
})

// 请求拦截器，在请求发送前进行处理
//config包含的这我们发送请求的一些头部、参数等。
request.interceptors.request.use((config) => {
    //token
    let whiteLis = WEBconfig.whiteListApi// 获取白名单列表
    let url = config.url // 获取请求的 URL
    let token = localStorage.getItem('token')
    // @ts-ignore
    // 如果请求的 URL 不在白名单中且存在 token，则将 token 添加到请求头中
    if (!whiteLis.indexOf(url) && token) {
        config.headers.token = token
    }
    //密钥 - secretId+特殊的算法 = 密钥-
    // @ts-ignore
    let secret = md5(WEBconfig.secretId + new Date().toString())
    config.headers.secret = secret
    return config
}, error => {
    // 请求拦截器发生错误时的处理
    console.error('Request interceptor error:', error)
    // 返回一个带有拒绝状态的 Promise 对象
    return Promise.reject(error)
})

// 响应拦截器，在收到响应后进行处理
request.interceptors.request.use((res) => {
    //响应统一处理
    const { data } = res
    const status = data?.code || 200// 获取响应状态码，默认为 200
    const message = data?.msg || '未知错误'// 获取响应消息，默认为 '未知错误'
    // 如果状态码为 401，则表示权限错误，跳转到登录页面
    if (status === 401) {
        // 处理权限错误，跳转到登录页面
        alert('你没有权限')
        router.push('/login')
        // 返回一个带有拒绝状态的 Promise 对象，并附带错误信息
        return Promise.reject(new Error(message))
    } else if (status !== 200) {
        // 其他错误情况的处理
        alert(`错误码：${status}，错误信息：${message}`)
        return Promise.reject(new Error(message))
    }
    return res
}, error => {//相应失败的拦截
    console.error('Response interceptor error:', error)
    alert('响应失败，请稍后重试')
    return Promise.reject(new Error(error))
})

// 导出自定义配置的 axios 实例
export default request;

/**
 *  在这个文件中去要做的事情：
 *      1、基本全局配置
 *          如 baseURL，超时时间等
 *      2、Token，密钥等
 *          处于权限和安全考虑的密钥设置到请求头
 *      3、相应的统一基本处理
 *          主要针对于错误的情况做全局统一处理
 * 
 *  baseURL：请求的基本URL
 *  timeout：请求的超时时间
 *  responseType：指定服务器响应的数据类型
 *  withCredentials：用于指定是否应该在跨域请求中发送凭证。
*/