msg = """**************************************************
欢迎使用【学生信息管理系统】V1.0
请选择你想要进行的操作
1. 新建学生信息
2. 显示全部信息
3. 查询学生信息
4. 删除学生信息
5. 修改学生信息
Python小白学习交流群：711312441
问题解答：python5201
 
0. 退出系统
**************************************************"""
 
f = open('学生信息.txt', encoding='utf-8')
student_info = []
info_list = f.readlines()
for info in info_list:
    content = info.replace('\n', '').split(',')
    dit = {
        '姓名': content[0],
        '语文': content[1],
        '数学': content[2],
        '英语': content[3],
        '总分': content[4],
    }
    student_info.append(dit)
 
# 死循环
while True:
    # 输出内容
    print(msg)
    # 选择输入进行操作 序号:
    num = input('请输入你操作序号: ')
    # 判断输入内容是什么, 根据不同操作情况, 进入不同界面
    if num == '1':
        print('新建学生信息')
        # 输入相应数据内容 input输入返回字符串
        name = input('请输入学生姓名: ')
        chinese = input('请输入学生语文成绩: ')
        math = input('请输入学生数学成绩: ')
        english = input('请输入学生英语成绩: ')
        # 字符串 --> + 拼接
        score = int(chinese) + int(math) + int(english)
        # 创建字典
        student_dit = {
            '姓名': name,
            '语文': chinese,
            '数学': math,
            '英语': english,
            '总分': score,
        }
        # 列表添加元素
        student_info.append(student_dit)
 
 
    elif num == '2':
        print('显示全部信息')
        print('姓名\t\t语文\t\t数学\t\t英语\t\t总分')
        # for循环遍历
        for student in student_info:
            print(
                student['姓名'] + '\t\t' +
                str(student['语文']) + '\t\t\t' +
                str(student['数学']) + '\t\t\t' +
                str(student['英语']) + '\t\t\t' +
                str(student['总分'])
            )
 
    elif num == '3':
        print('查询学生信息')
        # 输入查询学生姓名
        name = input('请输入学生姓名: ')
        for student in student_info:
            # 判断是否有这个学生
            if student['姓名'] == name:
                print('姓名\t\t语文\t\t数学\t\t英语\t\t总分')
                print(
                    student['姓名'] + '\t\t' +
                    str(student['语文']) + '\t\t\t' +
                    str(student['数学']) + '\t\t\t' +
                    str(student['英语']) + '\t\t\t' +
                    str(student['总分'])
                )
                break
        else:
            print('查无此人')
 
 
    elif num == '4':
        print('删除学生信息')
        # 输入查询学生姓名
        name = input('请输入学生姓名: ')
        for student in student_info:
            # 判断是否有这个学生
            if student['姓名'] == name:
                print('姓名\t\t语文\t\t数学\t\t英语\t\t总分')
                print(
                    student['姓名'] + '\t\t' +
                    str(student['语文']) + '\t\t\t' +
                    str(student['数学']) + '\t\t\t' +
                    str(student['英语']) + '\t\t\t' +
                    str(student['总分'])
                )
                word = input('是否要开除这个学生(y/n): ')
                if word == 'y' or word == 'Y':
                    # 删除学生信息, 相当于删除列表里面元素
                    student_info.remove(student)
                    break
                elif word == 'n' or word == 'N':
                    break
                else:
                    print('操作失误')
        else:
            print('查无此人')
 
    elif num == '5':
        print('修改学生信息')
        # 输入查询学生姓名
        name = input('请输入学生姓名: ')
        for student in student_info:
            # 判断是否有这个学生
            if student['姓名'] == name:
                print('姓名\t\t语文\t\t数学\t\t英语\t\t总分')
                print(
                    student['姓名'] + '\t\t' +
                    str(student['语文']) + '\t\t\t' +
                    str(student['数学']) + '\t\t\t' +
                    str(student['英语']) + '\t\t\t' +
                    str(student['总分'])
                )
                word = input('是否要修改这个学生(y/n): ')
                if word == 'y' or word == 'Y':
                    # 修改学生信息
                    name = input('请输入学生姓名: ')
                    chinese = input('请输入学生语文成绩: ')
                    math = input('请输入学生数学成绩: ')
                    english = input('请输入学生英语成绩: ')
                    # 字符串 --> + 拼接
                    score = int(chinese) + int(math) + int(english)
                    # 字典修改值
                    student['姓名'] = name
                    student['语文'] = chinese
                    student['数学'] = math
                    student['英语'] = english
                    student['总分'] = score
                    print(f'{student["姓名"]}信息修改成功...')
 
                elif word == 'n' or word == 'N':
                    continue
                else:
                    print('操作失误')
                break
        else:
            print('查无此人')
 
 
    elif num == '0':
        print('退出系统')
        with open('学生信息.txt', mode='w', encoding='utf-8') as f:
            for student in student_info:
                f.write(f'{student["姓名"]},{student["语文"]},{student["数学"]},{student["英语"]},{student["总分"]}')
                f.write('\n')
        exit()  # 退出
        # break
    else:
        print('请正确输入内容')