#!/bin/bash
export CUDA_VISIBLE_DEVICES=7

python infer.py \
    --attention True \
    --src_lang en --tar_lang vi \
    --num_layers 2 \
    --hidden_size 512 \
    --src_vocab_size 17191 \
    --tar_vocab_size 7709 \
    --batch_size 1 \
    --dropout 0.2 \
    --init_scale  0.1 \
    --max_grad_norm 5.0 \
    --vocab_prefix data/en-vi/vocab \
    --infer_file data/en-vi/tst2013.en \
    --reload_model attention_models/epoch_10 \
    --infer_output_file attention_infer_output/infer_output.txt \
    --beam_size 10 \
    --use_gpu True


