import numpy as np

from pytracking.features import deep
from pytracking.features.extractor import MultiResolutionExtractor
from pytracking.utils import TrackerParams, FeatureParams


def parameters():
    params = TrackerParams()

    # These are usually set from outside
    params.debug = 0  # Debug level
    params.visualization = False  # Do visualization

    # Use GPU or not (IoUNet requires this to be True)
    params.use_gpu = True

    # Feature specific parameters
    deep_params = TrackerParams()

    # Patch sampling parameters
    params.exemplar_size = 127
    params.instance_size = 287
    params.base_size = 0
    params.context_amount = 0.5
    
    # Anchor parameters
    params.anchor_stride = 8
    params.anchor_ratios = [0.33, 0.5, 1, 2, 3]
    params.anchor_scales = [8]

    # Tracking parameters
    params.penalty_k = 0.18
    params.window_influence = 0.41
    params.lr = 0.05

    # Setup the feature extractor
    deep_fparams = FeatureParams(feature_params=[deep_params])
    deep_feat = deep.SRPNAlexNet(fparams=deep_fparams)
    params.features = MultiResolutionExtractor([deep_feat])

    return params
