import sys
import paddle.fluid as fluid
import logging

logging.basicConfig()
logger = logging.getLogger(__name__)

__all__ = ['check_version']


def check_version():
    """
    Log error and exit when the installed version of paddlepaddle is
    not satisfied.
    """
    err = "PaddlePaddle version 1.6.1 or higher is required, " \
          "or a suitable develop version is satisfied as well. \n" \
          "Please make sure the version is good with your code." \

    try:
        fluid.require_version('1.6.1')
    except Exception as e:
        logger.error(err)
        sys.exit(1)
