# 1. Models

## 1.1 Model Introduction
This section introduces basic information of every model, including model background, application scenarios, quick start, and model principles, which can help you understand the model in an all-round way. 

## 1.2 Model Space
This section provides all the code for online experience, which can implement a model-based visual demo app. You can download, preview, and edit (not yet available) your code, or you can use Streamlit and Gradio.

## 1.3 Model Download
This section provides  model inference files and pre-trained model files in all task scenarios of the model, where you can obtain and download the model directly. 

## 1.4 Model Benchmark
This section provides model training and inference benchmarks, including software environment and hardware environment, datasets, effects of training and inference metrics. 

## 1.5 Model Examples
This section provides model-related industry example projects. Every example is derived from real business scenarios and implemented through complete codes, providing a full-process solution from data preparation to model deployment. You can click [Run] to feel the actual landing effect of the model. 

# 2. Quick Experience

## 2.1 Study in AI Studio
In this way, you can directly jump to the model project page in AI Studio corresponding. After logging in, you can directly select machine resources and run them. All the documents and codes will be copied to the project. Welcome to experience online.

Note: AI Studio is an artificial intelligence learning and training community based on PaddlePaddle, providing developers with an efficient, easy-to-use learning and development environment, rich systematic courses, massive open source practice projects and high-value AI competitions. It also provides an educational version to support teachers in universities and institutions to easily implement AI teaching, and help the cultivation of deep learning talents.

## 2.2 Practice in BML 
In this way, you can directly jump to the model project page corresponding to the BML AI platform. After logging in, you can directly select the machine resources and run them. All the documents and codes will be copied to the project. 

Note: BML full-featured AI development platform is a machine learning integrated development environment for enterprise and individual developers, providing full management services from data processing, model training, model management to model inference for classical machine learning and deep learning. It can help users build, train and deploy models faster.


## 2.3 Download Files to Your Computer
In this way, you can directly download the files to your local machine for use and experience in your own environment. It should be noted that you need to install basic environment of PaddlePaddle in advance. [Install PaddlePaddle](https://www.paddlepaddle.org.cn/install)

Note: The compressed package does not contain model training files and model inference files.

# 3 Welcome to Contribute
All source files are open-sourced in the PaddlePaddle industrial models([Models in GitHub](https://github.com/PaddlePaddle/models)), ([Models in Gitee](https://gitee.com/PaddlePaddle/models). Welcomed developers to contribute.
