# TensorFlow-Fluid接口对应表

本文档基于TensorFlow v1.13梳理了常用API与PaddlePaddle API对应关系和差异分析。根据文档对应关系，有TensorFlow使用经验的用户，可根据对应关系，快速熟悉PaddlePaddle的接口使用 。  

| 序号 | TensorFlow接口                                               | PaddlePaddle接口                                             | 备注                                                         |
| ---- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| 1    | [tf.abs](https://www.tensorflow.org/api_docs/python/tf/abs)  | [fluid.layers.abs](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#abs) | 功能一致                                                     |
| 2    | [tf.add](https://www.tensorflow.org/api_docs/python/tf/add)  | [fluid.layers.elementwise_add](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#elementwise_add) | 功能一致                                                     |
| 3    | [tf.argmax](https://www.tensorflow.org/api_docs/python/tf/argmax) | [fluid.layers.argmax](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#argmax) | 功能一致                                                     |
| 4    | [tf.argmin](https://www.tensorflow.org/api_docs/python/tf/argmin) | [fluid.layers.argmin](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#argmin) | 功能一致                                                     |
| 5    | [tf.assign](https://www.tensorflow.org/api_docs/python/tf/assign) | [fluid.layers.assign](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#assign) | 功能一致                                                     |
| 6    | [tf.assign_add](https://www.tensorflow.org/api_docs/python/tf/assign_add) | [fluid.layers.increment](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#increment) | 功能一致                                                     |
| 7    | [tf.case](https://www.tensorflow.org/api_docs/python/tf/case) | [fluid.layers.Switch](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#Switch) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.case.md) |
| 8    | [tf.cast](https://www.tensorflow.org/api_docs/python/tf/cast) | [fluid.layers.cast](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#cast) | 功能一致                                                     |
| 9    | [tf.clip_by_global_norm](https://www.tensorflow.org/api_docs/python/tf/clip_by_global_norm) | [fluid.clip.GradientClipByGlobalNorm](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/clip_cn.html#gradientclipbyglobalnorm) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.clip_by_global_norm.md) |
| 10   | [tf.clip_by_norm](https://www.tensorflow.org/api_docs/python/tf/clip_by_norm) | [fluid.layers.clip_by_norm](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.clip_by_norm) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.clip_by_norm.md) |
| 11   | [tf.clip_by_value](https://www.tensorflow.org/api_docs/python/tf/clip_by_value) | [fluid.layers.clip](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#clip) | 功能一致                                                     |
| 12   | [tf.concat](https://www.tensorflow.org/api_docs/python/tf/concat) | [fluid.layers.concat](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.concat) | 功能一致                                                     |
| 13   | [tf.cond](https://www.tensorflow.org/api_docs/python/tf/cond) | [fluid.layers.ifElse](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#ifElse) | 功能一致                                                     |
| 14   | [tf.constant](https://www.tensorflow.org/api_docs/python/tf/constant) | [fluid.layers.fill_constant](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#fill_constant) | 功能一致                                                     |
| 15   | [tf.contrib.layers.batch_norm](https://www.tensorflow.org/api_docs/python/tf/contrib/layers/batch_norm) | [fluid.layers.batch_norm](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#batch_norm) | 功能一致                                                     |
| 16   | [tf.contrib.layers.flatten](https://www.tensorflow.org/api_docs/python/tf/contrib/layers/flatten) | [fluid.layers.flatten](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#flatten) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.contrib.layers.flatten.md) |
| 17   | [tf.contrib.layers.fully_connected](https://www.tensorflow.org/api_docs/python/tf/contrib/layers/fully_connected) | [fluid.layers.fc](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#fc) | 功能一致                                                     |
| 18   | [tf.contrib.layers.one_hot_encoding](https://www.tensorflow.org/api_docs/python/tf/contrib/layers/one_hot_encoding) | [fluid.layers.one_hot](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#one_hot) | 功能一致                                                     |
| 19   | [tf.contrib.layers.softmax](https://www.tensorflow.org/api_docs/python/tf/contrib/layers/softmax) | [fluid.layers.softmax](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#softmax) | 功能一致                                                     |
| 20   | [tf.contrib.layers.xavier_initializer](https://www.tensorflow.org/api_docs/python/tf/contrib/layers/xavier_initializer) | [fluid.initializer.Xavier](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/initializer_cn.html#xavier) | 功能一致                                                     |
| 21   | [tf.contrib.rnn.GRUCell](https://www.tensorflow.org/api_docs/python/tf/contrib/rnn/GRUCell) | [fluid.layers.gru_unit](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#gru_unit) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.contrib.rnn.GRUCell.md) |
| 22   | [tf.contrib.rnn.MultiRNNCell](https://www.tensorflow.org/api_docs/python/tf/contrib/rnn/MultiRNNCell) | 无相应接口                                                   | [Paddle实现方法](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.rnn_cell.MultiRNNCell.md) |
| 23   | [tf.contrib.rnn.static_rnn](https://www.tensorflow.org/api_docs/python/tf/contrib/rnn/static_rnn) | [fluid.layers.DynamicRNN](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#dynamicrnn) | 功能一致                                                     |
| 24   | [tf.convert_to_tensor](https://www.tensorflow.org/api_docs/python/tf/convert_to_tensor) | [fluid.layers.assign](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#assign) | 功能一致                                                     |
| 25   | [tf.cos](https://www.tensorflow.org/api_docs/python/tf/cos)  | [fluid.layers.cos](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#cos) | 功能一致                                                     |
| 26   | [tf.div](https://www.tensorflow.org/api_docs/python/tf/div)  | [fluid.layers.elementwise_div](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.elementwise_div) | 功能一致                                                     |
| 27   | [tf.divide](https://www.tensorflow.org/api_docs/python/tf/divide) | [fluid.layers.elementwise_div](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#elementwise_div) | 功能一致                                                     |
| 28   | [tf.dropout](https://www.tensorflow.org/api_docs/python/tf/dropout) | [fluid.layers.dropout](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.dropout) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.dropout.md) |
| 29   | [tf.equal](https://www.tensorflow.org/api_docs/python/tf/equal) | [运算符==](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/compare_op.md) | 功能一致                                                     |
| 30   | [tf.exp](https://www.tensorflow.org/api_docs/python/tf/exp)  | [fluid.layers.exp](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#exp) | 功能一致                                                     |
| 31   | [tf.expand_dims](https://www.tensorflow.org/api_docs/python/tf/expand_dims) | [fluid.layers.unsqueeze](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#unsqueeze) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.expand_dims.md) |
| 32   | [tf.fill](https://www.tensorflow.org/api_docs/python/tf/fill) | [fluid.layers.fill_constant](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.fill_constant) | 功能一致                                                     |
| 33   | [tf.floor](https://www.tensorflow.org/api_docs/python/tf/floor) | [fluid.layers.floor](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#floor) | 功能一致                                                     |
| 34   | [tf.gather](https://www.tensorflow.org/api_docs/python/tf/gather) | [fluid.layers.gather](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.gather) | 功能一致                                                     |
| 35   | [tf.greater](https://www.tensorflow.org/api_docs/python/tf/greater) | [运算符>](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/compare_op.md) | 功能一致                                                     |
| 36   | [tf.greater_equal](https://www.tensorflow.org/api_docs/python/tf/greater_equal) | [运算符>=](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/compare_op.md) | 功能一致                                                     |
| 37   | [tf.image.non_max_suppression](https://www.tensorflow.org/api_docs/python/tf/image/non_max_suppression) | [fluid.layers.multiclass_nms](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.multiclass_nms) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.image.non_max_suppression.md) |
| 38   | [tf.image.resize_bilinear](https://www.tensorflow.org/api_docs/python/tf/image/resize_bilinear) | [fluid.layers.resize_bilinear](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.resize_bilinear) | 功能一致                                                     |
| 39   | [tf.image.resize_images](https://www.tensorflow.org/api_docs/python/tf/image/resize_images) | [fluid.layers.image_resize](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.image_resize) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.image.resize_images.md) |
| 40   | [tf.image.resize_nearest_neighbor](https://www.tensorflow.org/api_docs/python/tf/image/resize_nearest_neighbor) | [fluid.layers.resize_nearest](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.resize_nearest) | 功能一致                                                     |
| 41   | [tf.is_finite](https://www.tensorflow.org/api_docs/python/tf/is_finite) | [fluid.layers.isfinite](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#isfinite) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.math.is_finite.md) |
| 42   | [tf.layers.batch_normalization](https://www.tensorflow.org/api_docs/python/tf/layers/batch_normalization) | [fluid.layers.batch_norm](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.batch_norm) | 功能一致                                                     |
| 43   | [tf.layers.conv2d](https://www.tensorflow.org/api_docs/python/tf/layers/conv2d) | [fluid.layers.conv2d](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.conv2d) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.layers.conv2d.md) |
| 44   | [tf.layers.dense](https://www.tensorflow.org/api_docs/python/tf/layers/dense) | [fluid.layers.fc](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#fc) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.layers.dense.md) |
| 45   | [tf.layers.dropout](https://www.tensorflow.org/api_docs/python/tf/layers/dropout) | [fluid.layers.dropout](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#dropout) | 功能一致                                                     |
| 46   | [tf.layers.Dropout](https://www.tensorflow.org/api_docs/python/tf/layers/Dropout) | [fluid.layers.dropout](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#dropout) | 功能一致                                                     |
| 47   | [tf.layers.flatten](https://www.tensorflow.org/api_docs/python/tf/layers/flatten) | [fluid.layers.flatten](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.flatten) | 功能一致                                                     |
| 48   | [tf.less](https://www.tensorflow.org/api_docs/python/tf/less) | [运算符<](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/compare_op.md) | 功能一致                                                     |
| 49   | [tf.less_equal](https://www.tensorflow.org/api_docs/python/tf/less_equal) | [运算符<=](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/compare_op.md) | 功能一致                                                     |
| 50   | [tf.log](https://www.tensorflow.org/api_docs/python/tf/log)  | [fluid.layers.log](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.log) | 功能一致                                                     |
| 51   | [tf.logical_and](https://www.tensorflow.org/api_docs/python/tf/logical_and) | [fluid.layers.logical_and](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#logical_and) | 功能一致                                                     |
| 52   | [tf.logical_not](https://www.tensorflow.org/api_docs/python/tf/logical_not) | [fluid.layers.logical_not](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#logical_not) | 功能一致                                                     |
| 53   | [tf.logical_or](https://www.tensorflow.org/api_docs/python/tf/logical_or) | [fluid.layers.logical_or](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#logical_or) | 功能一致                                                     |
| 54   | [tf.losses.mean_squared_error](https://www.tensorflow.org/api_docs/python/tf/losses/mean_squared_error) | [fluid.layers.square_error_cost](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#square_error_cost) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.losses.mean_and_squared_error.md) |
| 55   | [tf.losses.sigmoid_cross_entropy](https://www.tensorflow.org/api_docs/python/tf/losses/sigmoid_cross_entropy) | [fluid.layers.sigmoid_cross_entropy_with_logits](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#sigmoid_cross_entropy_with_logits) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.losses.sigmoid_cross_entropy.md) |
| 56   | [tf.losses.softmax_cross_entropy](https://www.tensorflow.org/api_docs/python/tf/losses/softmax_cross_entropy) | [fluid.layers.softmax_with_cross_entropy](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.softmax_with_cross_entropy) | 功能一致                                                     |
| 57   | [tf.matmul](https://www.tensorflow.org/api_docs/python/tf/matmul) | [fluid.layers.matmul](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#matmul) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.matmul.md) |
| 58   | [tf.maximum](https://www.tensorflow.org/api_docs/python/tf/maximum) | [fluid.layers.elementwise_max](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.elementwise_max) | 功能一致                                                     |
| 59   | [tf.metrics.accuracy](https://www.tensorflow.org/api_docs/python/tf/metrics/accuracy) | [fluid.layers.accuracy](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.accuracy) | 功能一致                                                     |
| 60   | [tf.metrics.mean](https://www.tensorflow.org/api_docs/python/tf/metrics/mean) | [fluid.layers.mean](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#mean) | 功能一致                                                     |
| 61   | [tf.minimum](https://www.tensorflow.org/api_docs/python/tf/minimum) | [fluid.layers.elementwise_min](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#elementwise_min) | 功能一致                                                     |
| 62   | [tf.multiply](https://www.tensorflow.org/api_docs/python/tf/multiply) | [fluid.layers.elementwise_mul](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#elementwise_mul) | 功能一致                                                     |
| 63   | [tf.nn.avg_pool](https://www.tensorflow.org/api_docs/python/tf/nn/avg_pool) | [fluid.layers.pool2d](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.pool2d) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.avg_pool.md) |
| 64   | [tf.nn.batch_normalization](https://www.tensorflow.org/api_docs/python/tf/nn/batch_normalization) | [fluid.layers.batch_norm](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.batch_norm) | 功能一致                                                     |
| 65   | [tf.nn.bidirectional_dynamic_rnn](https://www.tensorflow.org/api_docs/python/tf/nn/bidirectional_dynamic_rnn) | 无相应接口                                                   | [Paddle实现方法](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.bidirectional_dynamic_rnn.md) |
| 66   | [tf.nn.conv2d](https://www.tensorflow.org/api_docs/python/tf/nn/conv2d) | [fluid.layers.conv2d](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.conv2d) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.conv2d.md) |
| 67   | [tf.nn.conv2d_transpose](https://www.tensorflow.org/api_docs/python/tf/nn/conv2d_transpose) | [fluid.layers.conv2d_transpose](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.conv2d_transpose) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.conv2d_transpose.md) |
| 68   | [tf.nn.conv3d_transpose](https://www.tensorflow.org/api_docs/python/tf/nn/conv3d_transpose) | [fluid.layers.conv3d_transpose](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.conv2d_transpose) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.conv3d_transpose.md) |
| 69   | [tf.nn.depthwise_conv2d](https://www.tensorflow.org/api_docs/python/tf/nn/depthwise_conv2d) | [fluid.layers.conv2d](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.conv2d) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.depthwise_conv2d.md) |
| 70   | [tf.nn.dynamic_rnn](https://www.tensorflow.org/api_docs/python/tf/nn/dynamic_rnn) | [fluid.layers.DynamicRNN](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#DynamicRNN) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.dynamic_rnn.md) |
| 71   | [tf.nn.l2_normalize](https://www.tensorflow.org/api_docs/python/tf/nn/l2_normalize) | [fluid.layers.l2_normalize](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#l2_normalize) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.l2_normalize.md) |
| 72   | [tf.nn.leaky_relu](https://www.tensorflow.org/api_docs/python/tf/nn/leaky_relu) | [fluid.layers.leaky_relu](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.leaky_relu) | 功能一致                                                     |
| 73   | [tf.nn.lrn](https://www.tensorflow.org/api_docs/python/tf/nn/lrn) | [fluid.layers.lrn](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.lrn) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.lrn.md) |
| 74   | [tf.nn.max_pool](https://www.tensorflow.org/api_docs/python/tf/nn/max_pool) | [fluid.layers.pool2d](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.pool2d) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.max_pool.md) |
| 75   | [tf.nn.relu](https://www.tensorflow.org/api_docs/python/tf/nn/relu) | [fluid.layers.relu](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#relu) | 功能一致                                                     |
| 76   | [tf.nn.relu6](https://www.tensorflow.org/api_docs/python/tf/nn/relu6) | [fluid.layers.relu6](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.relu6) | 功能一致                                                     |
| 77   | [tf.nn.rnn_cell.LSTMCell](https://www.tensorflow.org/api_docs/python/tf/nn/rnn_cell/LSTMCell) | [fluid.layers.lstm_unit](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#lstm_unit) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.rnn_cell.LSTMCell.md) |
| 78   | [tf.nn.separable_conv2d](https://www.tensorflow.org/api_docs/python/tf/nn/separable_conv2d) | 无相应接口                                                   | [Paddle实现方法](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.separable_conv2d.md) |
| 79   | [tf.nn.sigmoid](https://www.tensorflow.org/api_docs/python/tf/nn/sigmoid) | [fluid.layers.sigmoid](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#sigmoid) | 功能一致                                                     |
| 80   | [tf.nn.sigmoid_cross_entropy_with_logits](https://www.tensorflow.org/api_docs/python/tf/nn/sigmoid_cross_entropy_with_logits) | [fluid.layers.sigmoid_cross_entropy_with_logits](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#sigmoid_cross_entropy_with_logits) | 功能一致                                                     |
| 81   | [tf.nn.softmax](https://www.tensorflow.org/api_docs/python/tf/nn/softmax) | [fluid.layers.softmax](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#softmax) | 功能一致 |
| 82   | [tf.nn.softmax_cross_entropy_with_logits](https://www.tensorflow.org/api_docs/python/tf/nn/softmax_cross_entropy_with_logits) | [fluid.layers.softmax_with_cross_entropy](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#softmax_with_cross_entropy) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.softmax_cross_entropy_with_logits.md) |
| 83   | [tf.nn.softplus](https://www.tensorflow.org/api_docs/python/tf/nn/softplus) | [fluid.layers.softplus](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#softplus) | 功能一致                                                     |
| 84   | [tf.nn.softsign](https://www.tensorflow.org/api_docs/python/tf/nn/softsign) | [fluid.layers.softsign](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.softsign) | 功能一致                                                     |
| 85   | [tf.nn.tanh](https://www.tensorflow.org/api_docs/python/tf/nn/tanh) | [fluid.layers.tanh](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#tanh) | 功能一致                                                     |
| 86   | [tf.one_hot](https://www.tensorflow.org/api_docs/python/tf/one_hot) | [fluid.layers.one_hot](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.one_hot) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.one_hot.md) |
| 87   | [tf.ones](https://www.tensorflow.org/api_docs/python/tf/ones) | [fluid.layers.ones](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#ones) | 功能一致                                                     |
| 88   | [tf.ones_initializer](https://www.tensorflow.org/api_docs/python/tf/ones_initializer) | [fluid.initializer.Constant](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/initializer_cn.html#constant) | 功能一致                                                     |
| 89   | [tf.pad](https://www.tensorflow.org/api_docs/python/tf/pad)  | [fluid.layers.pad](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#pad) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.pad.md) |
| 90   | [tf.placeholder](https://www.tensorflow.org/api_docs/python/tf/placeholder) | [fluid.layers.data](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.data) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.placeholder.md) |
| 91   | [tf.pow](https://www.tensorflow.org/api_docs/python/tf/pow)  | [fluid.layers.pow](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#pow) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.pow.md) |
| 92   | [tf.print](https://www.tensorflow.org/api_docs/python/tf/print) | [fluid.layers.print](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#print) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.print.md) |
| 93   | [tf.py_func](https://www.tensorflow.org/api_docs/python/tf/py_func) | [fluid.layers.py_func](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.py_func) | 功能一致                                                     |
| 94   | [tf.random_normal](https://www.tensorflow.org/api_docs/python/tf/random_normal) | [fluid.layers.gaussian_random](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.gaussian_random) | 功能一致                                                     |
| 95   | [tf.random_normal_initializer](https://www.tensorflow.org/api_docs/python/tf/random_normal_initializer) | [fluid.initializer.Normal](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/initializer_cn.html#normal) | 功能一致                                                     |
| 96   | [tf.random_uniform](https://www.tensorflow.org/api_docs/python/tf/random_uniform) | [fluid.layers.uniform_random](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.uniform_random) | 功能一致                                                     |
| 97   | [tf.random_uniform_initializer](https://www.tensorflow.org/api_docs/python/tf/random_uniform_initializer) | [fluid.initializer.UniformInitializer](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/initializer_cn.html#uniforminitializer) | 功能一致                                                     |
| 98   | [tf.reduce_logsumexp](https://www.tensorflow.org/api_docs/python/tf/reduce_logsumexp) | 无相应接口                                                   | [Paddle实现方法](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.reduce_logsumexp.md) |
| 99   | [tf.reduce_max](https://www.tensorflow.org/api_docs/python/tf/reduce_max) | [fluid.layers.reduce_max](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#reduce_max) | 功能一致                                                     |
| 100  | [tf.reduce_mean](https://www.tensorflow.org/api_docs/python/tf/reduce_mean) | [fluid.layers.reduce_mean](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#reduce_mean) | 功能一致                                                     |
| 101  | [tf.reduce_min](https://www.tensorflow.org/api_docs/python/tf/reduce_min) | [fluid.layers.reduce_min](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#reduce_min) | 功能一致                                                     |
| 102  | [tf.reduce_sum](https://www.tensorflow.org/api_docs/python/tf/reduce_sum) | [fluid.layers.reduce_sum](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#reduce_sum) | 功能一致                                                     |
| 103  | [tf.reshape](https://www.tensorflow.org/api_docs/python/tf/reshape) | [fluid.layers.reshape](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.reshape) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.reshape.md) |
| 104  | [tf.reverse](https://www.tensorflow.org/api_docs/python/tf/reverse) | [fluid.layers.reverse](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#reverse) | 功能一致                                                     |
| 105  | [tf.reverse_sequence](https://www.tensorflow.org/api_docs/python/tf/reverse_sequence) | [fluid.layers.sequence_reverse](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#sequence_reverse) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.reverse_sequence.md) |
| 106  | [tf.reverse_v2](https://www.tensorflow.org/api_docs/python/tf/reverse_v2) | [fluid.layers.reverse](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.reverse) | 功能一致                                                     |
| 107  | [tf.round](https://www.tensorflow.org/api_docs/python/tf/round) | [fluid.layers.round](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.round) | 功能一致                                                     |
| 108  | [tf.rsqrt](https://www.tensorflow.org/api_docs/python/tf/rsqrt) | 无相应接口                                                   | [Paddle实现方法](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.math.rsqrt.md) |
| 109  | [tf.scalar_mul](https://www.tensorflow.org/api_docs/python/tf/scalar_mul) | [fluid.layers.scale](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#scale) | 功能一致                                                     |
| 110  | [tf.scatter_update](https://www.tensorflow.org/api_docs/python/tf/scatter_update) | [fluid.layers.scatter](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#scatter) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.scatter_update.md) |
| 111  | [tf.sequence_mask](https://www.tensorflow.org/api_docs/python/tf/sequence_mask) | [fluid.layers.sequence_mask](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#sequence_mask) | 功能一致                                                     |
| 112  | [tf.shape](https://www.tensorflow.org/api_docs/python/tf/shape) | [fluid.layers.shape](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#shape) | 功能一致                                                     |
| 113  | [tf.sigmoid](https://www.tensorflow.org/api_docs/python/tf/sigmoid) | [fluid.layers.sigmoid](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#sigmoid) | 功能一致                                                     |
| 114  | [tf.sin](https://www.tensorflow.org/api_docs/python/tf/sin)  | [fluid.layers.sin](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.sin) | 功能一致                                                     |
| 115  | [tf.slice](https://www.tensorflow.org/api_docs/python/tf/slice) | [fluid.layers.slice](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#slice) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.slice.md) |
| 116  | [tf.split](https://www.tensorflow.org/api_docs/python/tf/split) | [fluid.layers.split](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#split) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.split.md) |
| 117  | [tf.sqrt](https://www.tensorflow.org/api_docs/python/tf/sqrt) | [fluid.layers.sqrt](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#sqrt) | 功能一致                                                     |
| 118  | [tf.square](https://www.tensorflow.org/api_docs/python/tf/square) | [fluid.layers.square](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.square) | 功能一致                                                     |
| 119  | [tf.squared_difference](https://www.tensorflow.org/api_docs/python/tf/squared_difference) | 无相应接口                                                   | [Paddle实现方法](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.squared_difference.md) |
| 120  | [tf.squeeze](https://www.tensorflow.org/api_docs/python/tf/squeeze) | [fluid.layers.squeeze](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#squeeze) | 功能一致                                                     |
| 121  | [tf.stack](https://www.tensorflow.org/api_docs/python/tf/stack) | [fluid.layers.stack](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#stack) | 功能一致                                                     |
| 122  | [tf.stop_gradient](https://www.tensorflow.org/api_docs/python/tf/stop_gradient) | 无相应接口                                                   | [Paddle实现方法](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.stop_gradient.md) |
| 123  | [tf.subtract](https://www.tensorflow.org/api_docs/python/tf/subtract) | [fluid.layers.elementwise_sub](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.elementwise_sub) | 功能一致                                                     |
| 124  | [tf.tanh](https://www.tensorflow.org/api_docs/python/tf/tanh) | [fluid.layers.tanh](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#tanh) | 功能一致                                                     |
| 125  | [tf.tile](https://www.tensorflow.org/api_docs/python/tf/tile) | [fluid.layers.expand](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.expand) | 功能一致                                                     |
| 126  | [tf.top_k](https://www.tensorflow.org/api_docs/python/tf/top_k) | [fluid.layers.topk](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.topk) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.nn.top_k.md) |
| 127  | [tf.train.AdagradOptimizer](https://www.tensorflow.org/api_docs/python/tf/train/AdagradOptimizer) | [fluid.optimizer.AdagradOptimizer](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.optimizer.AdagradOptimizer) | 功能一致                                                     |
| 128  | [tf.train.AdamOptimizer](https://www.tensorflow.org/api_docs/python/tf/train/AdamOptimizer) | [fluid.optimizer.Adam](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.optimizer.Adam) | 功能一致                                                     |
| 129  | [tf.train.exponential_decay](https://www.tensorflow.org/api_docs/python/tf/train/exponential_decay) | [fluid.layers.exponential_decay](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.exponential_decay) | 功能一致                                                     |
| 130  | [tf.train.GradientDescentOptimizer](https://www.tensorflow.org/api_docs/python/tf/train/GradientDescentOptimizer) | [fluid.optimizer.SGDOptimizer](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/optimizer_cn.html#sgdoptimizer) | 功能一致                                                     |
| 131  | [tf.train.MomentumOptimizer](https://www.tensorflow.org/api_docs/python/tf/train/MomentumOptimizer) | [fluid.optimizer.MomentumOptimizer](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/optimizer_cn.html#momentumoptimizer) | 功能一致                                                     |
| 132  | [tf.train.polynomial_decay](https://www.tensorflow.org/api_docs/python/tf/train/polynomial_decay) | [fluid.layers.polynomial_decay](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.polynomial_decay) | 功能一致                                                     |
| 133  | [tf.train.RMSPropOptimizer](https://www.tensorflow.org/api_docs/python/tf/train/RMSPropOptimizer) | [fluid.optimizer.RMSPropOptimizer](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.optimizer.RMSPropOptimizer) | 功能一致                                                     |
| 134  | [tf.transpose](https://www.tensorflow.org/api_docs/python/tf/transpose) | [fluid.layers.transpose](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.transpose) | 功能一致                                                     |
| 135  | [tf.truediv](https://www.tensorflow.org/api_docs/python/tf/truediv) | [fluid.layers.elementwise_div](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.elementwise_div) | 功能一致                                                     |
| 136  | [tf.truncated_normal](https://www.tensorflow.org/api_docs/python/tf/truncated_normal) | [fluid.initializer.TruncatedNormal](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/initializer_cn.html#truncatednormal) | 功能一致                                                     |
| 137  | [tf.truncated_normal_initializer](https://www.tensorflow.org/api_docs/python/tf/truncated_normal_initializer) | [fluid.initializer.TruncatedNormal](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.initializer.TruncatedNormal) | 功能一致                                                     |
| 138  | [tf.unstack](https://www.tensorflow.org/api_docs/python/tf/unstack) | [fluid.layers.unstack](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#paddle.fluid.layers.unstack) | 功能一致                                                     |
| 139  | [tf.Variable](https://www.tensorflow.org/api_docs/python/tf/Variable) | [fluid.layers.create_parameter](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#create_parameter) | 功能一致                                                     |
| 140  | [tf.while_loop](https://www.tensorflow.org/api_docs/python/tf/while_loop) | [fluid.layers.While](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#While) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/blob/master/tensorflow2fluid/doc/tf.while_loop.md) |
| 141  | [tf.zeros](https://www.tensorflow.org/api_docs/python/tf/zeros) | [fluid.layers.zeros](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/layers_cn.html#zeros) | 功能一致                                                     |
| 142  | [tf.zeros_initializer](https://www.tensorflow.org/api_docs/python/tf/zeros_initializer) | [fluid.initializer.Constant](http://paddlepaddle.org/documentation/docs/zh/1.4/api_cn/initializer_cn.html#constant) | 功能一致                                                     |

