## 基础操作类API映射列表
该文档梳理了基础操作的PyTorch-PaddlePaddle API映射列表，主要包括了构造Tensor、数学计算、逻辑计算相关的API。

| 序号 | PyTorch API                                                  | PaddlePaddle API                                             | 备注                                                         |
| ---- | ------------------------------------------------------------ | ------------------------------------------------------------ | ------------------------------------------------------------ |
| 1    | [torch.set\_default\_dtype](https://pytorch.org/docs/stable/generated/torch.set_default_dtype.html) | [paddle.set\_default\_dtype](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/set_default_dtype_cn.html#set-default-dtype) | 功能一致                                                     |
| 2    | [torch.get\_default\_dtype](https://pytorch.org/docs/stable/generated/torch.get_default_dtype.html) | [paddle.get\_default\_dtype](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/get_default_dtype_cn.html#get-default-dtype) | 功能一致                                                     |
| 3    | [torch.numel](https://pytorch.org/docs/stable/generated/torch.numel.html) | [paddle.numel](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/numel_cn.html#numel) | 功能一致，参数名不一致                                       |
| 4    | [torch.tensor](https://pytorch.org/docs/stable/generated/torch.tensor.html?highlight=tensor#torch.tensor) | [paddle.to\_tensor](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/to_tensor_cn.html#to-tensor) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.tensor.md)                              |
| 5    | [torch.from\_numpy](https://pytorch.org/docs/stable/generated/torch.from_numpy.html?highlight=from_numpy#torch.from_numpy) | [paddle.to\_tensor](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/to_tensor_cn.html#to-tensor) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.from_numpy.md)                          |
| 6    | [torch.zeros](https://pytorch.org/docs/stable/generated/torch.zeros.html?highlight=zeros#torch.zeros) | [paddle.zeros](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/zeros_cn.html#zeros) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.zeros.md)                               |
| 7    | [torch.zeros_like](https://pytorch.org/docs/stable/generated/torch.zeros_like.html?highlight=zeros_like#torch.zeros_like) | [paddle.zeros_like](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/zeros_like_cn.html#zeros-like) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.zeros_like.md)                          |
| 8    | [torch.ones](https://pytorch.org/docs/stable/generated/torch.ones.html?highlight=ones#torch.ones) | [paddle.ones](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/ones_cn.html#ones) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.ones.md)                                |
| 9    | [torch.ones_like](https://pytorch.org/docs/stable/generated/torch.zeros_like.html?highlight=zeros_like#torch.zeros_like) | [paddle.ones_like](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/ones_like_cn.html#ones-like) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.ones_like.md)                           |
| 10   | [torch.empty](https://pytorch.org/docs/stable/generated/torch.empty.html?highlight=empty#torch.empty) | [paddle.empty](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/empty_cn.html#empty) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.empty.md)                               |
| 11   | [torch.empty_like](https://pytorch.org/docs/stable/generated/torch.empty_like.html?highlight=empty_like#torch.empty_like) | [paddle.empty_like](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/empty_like_cn.html#empty-like) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.empty_like.md)                          |
| 12   | [torch.full](https://pytorch.org/docs/stable/generated/torch.full.html?highlight=full#torch.full) | [paddle.full](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/full_cn.html#full) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.full.md)                    |
| 13   | [torch.full_like](https://pytorch.org/docs/stable/generated/torch.full_like.html?highlight=full_like#torch.full_like) | [paddle.full_like](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/full_like_cn.html#full-like) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.full_like.md)                           |
| 14   | [torch.arange](https://pytorch.org/docs/stable/generated/torch.arange.html?highlight=arange#torch.arange) | [paddle.arange](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/arange_cn.html#arange) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.arange.md)                   |
| 15   | [torch.range](https://pytorch.org/docs/stable/generated/torch.range.html?highlight=range#torch.range) | [paddle.arange](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/arange_cn.html#arange) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.range.md)                   |
| 16   | [torch.linspace](https://pytorch.org/docs/stable/generated/torch.linspace.html?highlight=linspace#torch.linspace) | [paddle.linspace](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/linspace_cn.html#linspace) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.linspace.md)                |
| 17   | [torch.eye](https://pytorch.org/docs/stable/generated/torch.eye.html?highlight=eye#torch.eye) | [paddle.eye](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/eye_cn.html#eye) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.eye.md)                     |
| 18   | [torch.cat](https://pytorch.org/docs/stable/generated/torch.cat.html?highlight=torch%20cat#torch.cat) | [paddle.concat](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/concat_cn.html#concat) | 功能一致，参数名不一致                                       |
| 19   | [torch.chunk](https://pytorch.org/docs/stable/generated/torch.chunk.html?highlight=chunk#torch.chunk) | [paddle.chunk](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/chunk_cn.html#chunk) | 功能一致，参数名不一致                                       |
| 20   | [torch.gather](https://pytorch.org/docs/stable/generated/torch.gather.html?highlight=gather#torch.gather) | [paddle.gather](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/gather_cn.html#gather) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.gather.md)                              |
| 21   | [torch.index\_select](https://pytorch.org/docs/stable/generated/torch.index_select.html?highlight=index_select#torch.index_select) | [paddle.index\_select](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/index_select_cn.html#index-select) | 功能一致，参数名不一致                                       |
| 22   | [torch.masked\_select](https://pytorch.org/docs/stable/generated/torch.masked_select.html?highlight=masked_sel#torch.masked_select) | [paddle.masked\_select](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/masked_select_cn.html#masked-select) | 功能一致，参数名不一致                                       |
| 23   | [torch.narrow](https://pytorch.org/docs/stable/generated/torch.narrow.html?highlight=narrow#torch.narrow) | [paddle.slice](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/slice_cn.html#slice) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.narrow.md)                              |
| 24   | [torch.nonzero](https://pytorch.org/docs/stable/generated/torch.nonzero.html?highlight=nonzero#torch.nonzero) | [paddle.nonzero](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/nonzero_cn.html#nonzero) | 功能一致，参数名不一致                                       |
| 25   | [torch.reshape](https://pytorch.org/docs/stable/generated/torch.reshape.html?highlight=reshape#torch.reshape) | [paddle.reshape](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/reshape_cn.html#reshape) | 功能一致，参数名不一致                                       |
| 26   | [torch.split](https://pytorch.org/docs/stable/generated/torch.split.html?highlight=split#torch.split) | [paddle.split](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/split_cn.html#split) | 功能一致，参数名不一致                                       |
| 27   | [torch.squeeze](https://pytorch.org/docs/stable/generated/torch.squeeze.html?highlight=squeeze#torch.squeeze) | [paddle.squeeze](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/squeeze_cn.html#squeeze) | 功能一致，参数名不一致                                       |
| 28   | [torch.stack](https://pytorch.org/docs/stable/generated/torch.stack.html?highlight=stack#torch.stack) | [paddle.stack](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/stack_cn.html#stack) | 功能一致，参数名不一致                                       |
| 29   | [torch.t](https://pytorch.org/docs/stable/generated/torch.t.html) | [paddle.t](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/t_cn.html#t) | 功能一致，参数名不一致                                       |
| 30   | [torch.transpose](https://pytorch.org/docs/stable/generated/torch.transpose.html?highlight=transpose#torch.transpose) | [paddle.transpose](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/transpose_cn.html#transpose) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.transpose.md)                           |
| 31   | [torch.unbind](https://pytorch.org/docs/stable/generated/torch.unbind.html?highlight=unbind#torch.unbind) | [paddle.unbind](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/unbind_cn.html#unbind) | 功能一致，参数名不一致                                       |
| 32   | [torch.unsqueeze](https://pytorch.org/docs/stable/generated/torch.unsqueeze.html?highlight=unsqueeze#torch.unsqueeze) | [paddle.unsqueeze](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/unsqueeze_cn.html#unsqueeze) | 功能一致，参数名不一致                                       |
| 33   | [torch.where](https://pytorch.org/docs/stable/generated/torch.where.html?highlight=where#torch.where) | [paddle.where](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/where_cn.html#where) | 功能一致                                                     |
| 34   | [torch.bernoulli](https://pytorch.org/docs/stable/generated/torch.bernoulli.html?highlight=bernoulli#torch.bernoulli) | [paddle.bernoulli](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/bernoulli_cn.html#bernoulli) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.bernoulli.md)               |
| 35   | [torch.multinomial](https://pytorch.org/docs/stable/generated/torch.multinomial.html?highlight=multinomial#torch.multinomial) | [paddle.multinomial](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/multinomial_cn.html#multinomial) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.multinomial.md)             |
| 36   | [torch.normal](https://pytorch.org/docs/stable/generated/torch.normal.html?highlight=normal#torch.normal) | [paddle.normal](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/normal_cn.html#normal) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.normal.md)                              |
| 37   | [torch.rand](https://pytorch.org/docs/stable/generated/torch.rand.html?highlight=rand#torch.rand) | [paddle.rand](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/rand_cn.html#rand) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.rand.md)                                |
| 38   | [torch.randint](https://pytorch.org/docs/stable/generated/torch.randint.html?highlight=randint#torch.randint) | [paddle.randint](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/randint_cn.html#randint) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.randint.md)                 |
| 39   | [torch.randn](https://pytorch.org/docs/stable/generated/torch.randn.html?highlight=ran%20dn#torch.randn) | [paddle.randn](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/randn_cn.html#randn) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.randn.md)                               |
| 40   | [torch.randperm](https://pytorch.org/docs/stable/generated/torch.randperm.html?highlight=randperm#torch.randperm) | [paddle.randperm](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/randperm_cn.html#randperm) | 功能一致，[参数不一致](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.randperm.md)                |
| 41   | [torch.save](https://pytorch.org/docs/stable/generated/torch.save.html?highlight=save#torch.save) | [paddle.save](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/save_cn.html#save) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.save.md)                                |
| 42   | [torch.load](https://pytorch.org/docs/stable/generated/torch.load.html?highlight=load#torch.load) | [paddle.load](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/load_cn.html#load) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.load.md)                                |
| 43   | [torch.abs](https://pytorch.org/docs/stable/generated/torch.abs.html?highlight=abs#torch.abs) | [paddle.abs](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/abs_cn.html#abs) | 功能一致，PaddlePaddle未定义`out`参数代表输出Tensor          |
| 44   | [torch.absolute](https://pytorch.org/docs/stable/generated/torch.absolute.html?highlight=absolute#torch.absolute) | [paddle.abs](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/abs_cn.html#abs) | 功能一致，PaddlePaddle未定义`out`参数代表输出Tensor          |
| 45   | [torch.acos](https://pytorch.org/docs/stable/generated/torch.acos.html?highlight=torch%20acos#torch.acos) | [paddle.acos](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/acos_cn.html#acos) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 46   | [torch.arccos](https://pytorch.org/docs/stable/generated/torch.arccos.html?highlight=arccos#torch.arccos) | [paddle.acos](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/acos_cn.html#acos) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 47   | [torch.add](https://pytorch.org/docs/stable/generated/torch.add.html?highlight=add#torch.add) | [padle.add](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/add_cn.html#add) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 48   | [torch.asin](https://pytorch.org/docs/stable/generated/torch.asin.html?highlight=asin#torch.asin) | [paddle.asin](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/asin_cn.html#asin) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 49   | [torch.arcsin](https://pytorch.org/docs/stable/generated/torch.arcsin.html?highlight=arcsin#torch.arcsin) | [paddle.asin](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/asin_cn.html#asin) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 50   | [torch.atan](https://pytorch.org/docs/stable/generated/torch.atan.html?highlight=atan#torch.atan) | [paddle.atan](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/atan_cn.html#atan) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 51   | [torch.arctan](https://pytorch.org/docs/stable/generated/torch.arctan.html?highlight=arctan#torch.arctan) | [paddle.atan](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/atan_cn.html#atan) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 52   | [torch.ceil](https://pytorch.org/docs/stable/generated/torch.ceil.html?highlight=ceil#torch.ceil) | [paddle.ceil](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/ceil_cn.html#ceil) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 53   | [torch.clamp](https://pytorch.org/docs/stable/generated/torch.clamp.html#torch.clamp) | [paddle.clip](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/clip_cn.html#clip) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 54   | [torch.conj](https://pytorch.org/docs/stable/generated/torch.conj.html?highlight=conj#torch.conj) | [paddle.conj](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/conj_cn.html#conj) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 55   | [torch.cos](https://pytorch.org/docs/stable/generated/torch.cos.html?highlight=cos#torch.cos) | [paddle.cos](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/cos_cn.html#cos) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 56   | [torch.cosh](https://pytorch.org/docs/stable/generated/torch.cosh.html?highlight=cosh#torch.cosh) | [paddle.cosh](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/cosh_cn.html#cosh) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 57   | [torch.div](https://pytorch.org/docs/stable/generated/torch.div.html?highlight=div#torch.div) | [paddle.divide](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/divide_cn.html#divide) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.div.md)                                 |
| 58   | [torch.divide](https://pytorch.org/docs/stable/generated/torch.divide.html?highlight=divide#torch.divide) | [paddle.divide](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/divide_cn.html#divide) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.divide.md)                              |
| 59   | [torch.erf](https://pytorch.org/docs/stable/generated/torch.erf.html?highlight=erf#torch.erf) | [paddle.erf](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/erf_cn.html#erf) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 60   | [torch.exp](https://pytorch.org/docs/stable/generated/torch.exp.html?highlight=exp#torch.exp) | [paddle.exp](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/exp_cn.html#exp) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 61   | [torch.floor](https://pytorch.org/docs/stable/generated/torch.floor.html?highlight=floor#torch.floor) | [paddle.floor](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/floor_cn.html#floor) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 62   | [torch.floor_divide](https://pytorch.org/docs/stable/generated/torch.floor_divide.html?highlight=floor_divide#torch.floor_divide) | [paddle.floor_divide](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/floor_divide_cn.html#floor-divide) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 63   | [torch.fmod](https://pytorch.org/docs/stable/generated/torch.fmod.html?highlight=fmod#torch.fmod) | [paddle.mod](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/mod_cn.html#mod) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 64   | [torch.log](https://pytorch.org/docs/stable/generated/torch.log.html?highlight=log#torch.log) | [paddle.log](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/log_cn.html#log) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 65   | [torch.log10](https://pytorch.org/docs/stable/generated/torch.log10.html?highlight=log10#torch.log10) | [paddle.log10](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/log10_cn.html#log10) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 66   | [torch.log1p](https://pytorch.org/docs/stable/generated/torch.log1p.html?highlight=log1p#torch.log1p) | [paddle.log1p](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/log1p_cn.html#log1p) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 67   | [torch.log2](https://pytorch.org/docs/stable/generated/torch.log2.html?highlight=log2#torch.log2) | [paddle.log2](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/log2_cn.html#log2) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 68   | [torch.logical_and](https://pytorch.org/docs/stable/generated/torch.logical_and.html?highlight=logical_and#torch.logical_and) | [paddle.logical_and](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/logical_and_cn.html#logical-and) | 功能一致，参数名不一致                                       |
| 69   | [torch.logical_not](https://pytorch.org/docs/stable/generated/torch.logical_not.html?highlight=logical_not#torch.logical_not) | [paddle.logical_not](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/logical_not_cn.html#logical-not) | 功能一致，参数名不一致                                       |
| 70   | [torch.logical_or](https://pytorch.org/docs/stable/generated/torch.logical_or.html?highlight=logical_or#torch.logical_or) | [paddle.logical_or](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/logical_or_cn.html#logical-or) | 功能一致，参数名不一致                                       |
| 71   | [torch.logical_xor](https://pytorch.org/docs/stable/generated/torch.logical_xor.html?highlight=logical_xor#torch.logical_xor) | [paddle.logical_xor](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/logical_xor_cn.html#logical-xor) | 功能一致，参数名不一致                                       |
| 72   | [torch.mul](https://pytorch.org/docs/stable/generated/torch.mul.html?highlight=torch%20mul#torch.mul) | [paddle.multiply](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/multiply_cn.html#multiply) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 73   | [torch.multiply](https://pytorch.org/docs/stable/generated/torch.multiply.html?highlight=multiply#torch.multiply) | [paddle.multiply](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/multiply_cn.html#multiply) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 74   | [torch.pow](https://pytorch.org/docs/stable/generated/torch.pow.html?highlight=pow#torch.pow) | [paddle.pow](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/pow_cn.html#pow) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 75   | [torch.real](https://pytorch.org/docs/stable/generated/torch.real.html?highlight=real#torch.real) | [paddle.real](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/real_cn.html#real) | 功能一致，参数名不一致                                       |
| 76   | [torch.reciprocal](https://pytorch.org/docs/stable/generated/torch.reciprocal.html?highlight=reciprocal#torch.reciprocal) | [paddle.reciprocal](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/reciprocal_cn.html#reciprocal) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 77   | [torch.remainder](https://pytorch.org/docs/stable/generated/torch.remainder.html?highlight=remainder#torch.remainder) | [paddle.mod](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/mod_cn.html#mod) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 78   | [torch.round](https://pytorch.org/docs/stable/generated/torch.round.html?highlight=round#torch.round) | [paddle.round](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/round_cn.html#round) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 79   | [torch.rsqrt](https://pytorch.org/docs/stable/generated/torch.rsqrt.html?highlight=rsqrt#torch.rsqrt) | [paddle.rsqrt](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/rsqrt_cn.html#rsqrt) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 80   | [torch.sign](https://pytorch.org/docs/stable/generated/torch.sign.html?highlight=sign#torch.sign) | [paddle.sign](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/sign_cn.html#sign) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 81   | [torch.sin](https://pytorch.org/docs/stable/generated/torch.sin.html?highlight=sin#torch.sin) | [paddle.sin](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/sin_cn.html#sin) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 82   | [torch.sinh](https://pytorch.org/docs/stable/generated/torch.sinh.html?highlight=sinh#torch.sinh) | [paddle.sinh](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/sinh_cn.html#sinh) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 83   | [torch.sqrt](https://pytorch.org/docs/stable/generated/torch.sqrt.html?highlight=sqrt#torch.sqrt) | [paddle.sqrt](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/sqrt_cn.html#sqrt) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 84   | [torch.argmax](https://pytorch.org/docs/stable/generated/torch.argmax.html?highlight=argmax#torch.argmax) | [paddle.argmax](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/argmax_cn.html#argmax) | 功能一致，参数名不一致                                       |
| 85   | [torch.argmin](https://pytorch.org/docs/stable/generated/torch.argmin.html?highlight=argmin#torch.argmin) | [paddle.argmin](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/argmin_cn.html#argmin) | 功能一致，参数名不一致                                       |
| 86   | [torch.max](https://pytorch.org/docs/stable/generated/torch.max.html?highlight=max#torch.max) | [paddle.max](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/max_cn.html#max) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 87   | [torch.min](https://pytorch.org/docs/stable/generated/torch.min.html?highlight=min#torch.min) | [paddle.min](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/min_cn.html#min) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 88   | [torch.square](https://pytorch.org/docs/stable/generated/torch.square.html?highlight=square#torch.square) | [paddle.square](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/square_cn.html#square) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 89   | [torch.sub](https://pytorch.org/docs/stable/generated/torch.sub.html?highlight=sub#torch.sub) | [paddle.subtract](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/subtract_cn.html#subtract) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.sub.md)                                     |
| 90   | [torch.subtract](https://pytorch.org/docs/stable/generated/torch.subtract.html?highlight=subtract#torch.subtract) | [paddle.subtract](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/subtract_cn.html#subtract) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.subtract.md)                                |
| 91   | [torch.tanh](https://pytorch.org/docs/stable/generated/torch.tanh.html?highlight=tanh#torch.tanh) | [paddle.tanh](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/tanh_cn.html#tanh) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 92   | [torch.true_divide](https://pytorch.org/docs/stable/generated/torch.true_divide.html?highlight=true_divide#torch.true_divide) | [paddle.divide](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/divide_cn.html#divide) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 93   | [torch.dist](https://pytorch.org/docs/stable/generated/torch.dist.html?highlight=dist) | [paddle.dist](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/dist_cn.html#dist) | 功能一致，参数名不一致                                       |
| 94   | [torch.logsumexp](https://pytorch.org/docs/stable/generated/torch.logsumexp.html?highlight=logsumexp#torch.logsumexp) | [paddle.logsumexp](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/logsumexp_cn.html#logsumexp) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 95   | [torch.mean](https://pytorch.org/docs/stable/generated/torch.mean.html?highlight=mean) | [paddle.mean](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/mean_cn.html#mean) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 96   | [torch.median](https://pytorch.org/docs/stable/generated/torch.median.html?highlight=median#torch.median) | [paddle.median](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/median_cn.html#median) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 97   | [torch.norm](https://pytorch.org/docs/stable/generated/torch.norm.html?highlight=norm#torch.norm) | [paddle.norm](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/norm_cn.html#norm) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor以及`dtype`参数代表输出Tensor类型 |
| 98   | [torch.prod](https://pytorch.org/docs/stable/generated/torch.prod.html?highlight=prod#torch.prod) | [paddle.prod](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/prod_cn.html#prod) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 99   | [torch.std](https://pytorch.org/docs/stable/generated/torch.std.html?highlight=std#torch.std) | [paddle.std](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/std_cn.html#std) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 100  | [torch.std_mean](https://pytorch.org/docs/stable/generated/torch.std_mean.html?highlight=std_mean#torch.std_mean) | 无对应实现                                                   | [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.std_mean.md)                                |
| 101  | [torch.sum](https://pytorch.org/docs/stable/generated/torch.sum.html?highlight=sum#torch.sum) | [paddle.sum](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/sum_cn.html#sum) | 功能一致，参数名不一致                                       |
| 102  | [torch.unique](https://pytorch.org/docs/stable/generated/torch.unique.html?highlight=unique#torch.unique) | [paddle.unique](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/unique_cn.html#unique) | [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.unique.md)                                  |
| 103  | [torch.var](https://pytorch.org/docs/stable/generated/torch.var.html?highlight=var#torch.var) | [paddle.var](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/var_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 104  | [torch.var_mean](https://pytorch.org/docs/stable/generated/torch.var_mean.html?highlight=var_mean#torch.var_mean) | 无对应实现                                                   | [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.var_mean.md)                                |
| 105  | [torch.allclose](https://pytorch.org/docs/stable/generated/torch.allclose.html?highlight=allclose#torch.allclose) | [paddle.allclose](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/allclose_cn.html) | 功能一致，参数名不一致                                       |
| 106  | [torch.argsort](https://pytorch.org/docs/stable/generated/torch.argsort.html?highlight=argsort#torch.argsort) | [paddle.argsort](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/argsort_cn.html) | 功能一致，参数名不一致                                       |
| 107  | [torch.eq](https://pytorch.org/docs/stable/generated/torch.eq.html?highlight=eq#torch.eq) | [paddle.equal](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/equal_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 108  | [torch.equal](https://pytorch.org/docs/stable/generated/torch.equal.html?highlight=eq#torch.equal) | [paddle.equal_all](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/equal_all_cn.html) | 功能一致，参数名不一致                                       |
| 109  | [torch.ge](https://pytorch.org/docs/stable/generated/torch.ge.html?highlight=ge#torch.ge) | [paddle.greater_equal](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/greater_equal_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 110  | [torch.gt](https://pytorch.org/docs/stable/generated/torch.gt.html?highlight=gt#torch.gt) | [paddle.greater_than](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/greater_than_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 111  | [torch.isfinite](https://pytorch.org/docs/stable/generated/torch.isfinite.html?highlight=isfinite#torch.isfinite) | [paddle.isfinite](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/isfinite_cn.html) | 功能一致，参数名不一致                                       |
| 112  | [torch.isinf](https://pytorch.org/docs/stable/generated/torch.isinf.html?highlight=isinf#torch.isinf) | [paddle.isinf](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/isinf_cn.html) | 功能一致，参数名不一致                                       |
| 113  | [torch.isnan](https://pytorch.org/docs/stable/generated/torch.isnan.html?highlight=isnan#torch.isnan) | [paddle.isnan](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/isnan_cn.html) | 功能一致，参数名不一致                                       |
| 114  | [torch.kthvalue](https://pytorch.org/docs/stable/generated/torch.kthvalue.html?highlight=kthvalue#torch.kthvalue) | 无对应实现                                                   | [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.kthvalue.md)                              |
| 115  | [torch.le](https://pytorch.org/docs/stable/generated/torch.le.html?highlight=le#torch.le) | [paddle.less_equal](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/less_equal_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 116  | [torch.lt](https://pytorch.org/docs/stable/generated/torch.lt.html?highlight=lt#torch.lt) | [paddle.less_than](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/less_than_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 117  | [torch.maximum](https://pytorch.org/docs/stable/generated/torch.maximum.html?highlight=max#torch.maximum) | [paddle.maximum](https://www.paddlepaddle.org.cn/documentation/docs/zh/2.0/api/paddle/tensor/math/maximum_cn.html#cn-api-paddle-tensor-maximum) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 118  | [torch.minimum](https://pytorch.org/docs/stable/generated/torch.minimum.html?highlight=minimum#torch.minimum) | [paddle.minimum](https://www.paddlepaddle.org.cn/documentation/docs/zh/2.0/api/paddle/tensor/math/minimum_cn.html#cn-api-paddle-tensor-minimum) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 119  | [torch.ne](https://pytorch.org/docs/stable/generated/torch.ne.html?highlight=ne#torch.ne) | [paddle.not_equal](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/not_equal_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 120  | [torch.sort](https://pytorch.org/docs/stable/generated/torch.sort.html?highlight=sort#torch.sort) | [paddle.argsort](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/argsort_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 121  | [torch.topk](https://pytorch.org/docs/stable/generated/torch.topk.html?highlight=topk#torch.topk) | [paddle.topk](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/topk_cn.html#topk) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 122  | [torch.cross](https://pytorch.org/docs/stable/generated/torch.cross.html?highlight=cross#torch.cross) | [paddle.cross](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/cross_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 123  | [torch.any](https://pytorch.org/docs/stable/generated/torch.any.html?highlight=any#torch.any) | [paddle.any](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/any_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 124  | [torch.cumsum](https://pytorch.org/docs/stable/generated/torch.cumsum.html?highlight=cumsum#torch.cumsum) | [paddle.cumsum](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/cumsum_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 125  | [torch.diag](https://pytorch.org/docs/stable/generated/torch.diag.html?highlight=diag#torch.diag) | [paddle.diag](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/diag_cn.html) |          [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.diag.md)                                                     |
| 126  | [torch.diag_embed](https://pytorch.org/docs/stable/generated/torch.diag_embed.html?highlight=diag_embed#torch.diag_embed) | [paddle.nn.functional.diag_embed](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/nn/functional/diag_embed_cn.html) | 功能一致                                                     |
| 127  | [torch.einsum](https://pytorch.org/docs/stable/generated/torch.einsum.html?highlight=einsum#torch.einsum) | paddlenlp.ops.einsum                                         | 功能一致，需要安装[paddlenlp](https://github.com/PaddlePaddle/PaddleNLP#pip%E5%AE%89%E8%A3%85) |
| 128  | [torch.flatten](https://pytorch.org/docs/stable/generated/torch.flatten.html?highlight=flatten#torch.flatten) | [paddle.flatten](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/flatten_cn.html) | 功能一致，参数名不一致                                       |
| 129  | [torch.flip](https://pytorch.org/docs/stable/generated/torch.flip.html?highlight=flip#torch.flip) | [paddle.flip](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/flip_cn.html) | 功能一致，参数名不一致                                       |
| 130  | [torch.rot90](https://pytorch.org/docs/stable/generated/torch.rot90.html?highlight=rot90#torch.rot90) | 无对应实现                                                   |            [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.rot90.md)                                             |
| 131  | [torch.meshgrid](https://pytorch.org/docs/stable/generated/torch.meshgrid.html?highlight=meshgrid#torch.meshgrid) | [paddle.meshgrid](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/meshgrid_cn.html) | 功能一致                                                     |
| 132  | [torch.roll](https://pytorch.org/docs/stable/generated/torch.roll.html?highlight=roll#torch.roll) | [paddle.roll](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/roll_cn.html) | 功能一致，参数名不一致                                       |
| 133  | [torch.tril](https://pytorch.org/docs/stable/generated/torch.tril.html?highlight=tril#torch.tril) | [paddle.tril](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/tril_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 134  | [torch.triu](https://pytorch.org/docs/stable/generated/torch.triu.html?highlight=triu#torch.triu) | [paddle.triu](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/triu_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 135  | [torch.bmm](https://pytorch.org/docs/stable/generated/torch.bmm.html?highlight=bmm#torch.bmm) | [paddle.bmm](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/bmm_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 136  | [torch.cholesky](https://pytorch.org/docs/stable/generated/torch.cholesky.html?highlight=cholesky#torch.cholesky) | [paddle.cholesky](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/cholesky_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 137  | [torch.dot](https://pytorch.org/docs/stable/generated/torch.dot.html?highlight=dot#torch.dot) | [paddle.dot](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/dot_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 138  | [torch.inverse](https://pytorch.org/docs/stable/generated/torch.inverse.html?highlight=inverse#torch.inverse) | [paddle.inverse](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/inverse_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 139  | [torch.trace](https://pytorch.org/docs/stable/generated/torch.trace.html?highlight=trace#torch.trace) | [paddle.trace](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/trace_cn.html) |   [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.trace.md)                                                           |
| 140  | [torch.addmv](https://pytorch.org/docs/stable/generated/torch.addmv.html?highlight=addmv#torch.addmv) | 无对应实现               |          [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.addmv.md)                                                     |
| 141  | [torch.addr](https://pytorch.org/docs/stable/generated/torch.addr.html?highlight=addr#torch.addr) | 无对应实现                                                   |              [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.addr.md)    |
| 142  | [torch.baddbmm](https://pytorch.org/docs/stable/generated/torch.baddbmm.html?highlight=baddbmm#torch.baddbmm) | 无对应实现                                                   |  [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.baddbmm.md)                                                            |
| 143  | [torch.addmm](https://pytorch.org/docs/stable/generated/torch.addmm.html?highlight=addmm#torch.addmm) | [paddle.addmm](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/addmm_cn.html) | 功能一致，参数名不一致，PaddlePaddle未定义`out`参数代表输出Tensor |
| 144  | [torch.chain_matmul](https://pytorch.org/docs/stable/generated/torch.chain_matmul.html?highlight=chain_matmul#torch.chain_matmul) | 无对应实现                                                   |                           [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.chain_matmul.md)      |
| 145  | [torch.cholesky_inverse](https://pytorch.org/docs/stable/generated/torch.cholesky_inverse.html?highlight=cholesky_inverse#torch.cholesky_inverse) | 无对应实现                                                   |  [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.cholesky_inverse.md)  |
| 146  | [torch.cholesky_solve](https://pytorch.org/docs/stable/generated/torch.cholesky_solve.html?highlight=cholesky_solve#torch.cholesky_solve) | 无对应实现                                                   |  [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.cholesky_solve.md)      |
| 147  | [torch.matmul](https://pytorch.org/docs/stable/generated/torch.matmul.html?highlight=matmul#torch.matmul) | [paddle.matmul](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/matmul_cn.html) |    [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.matmul.md) |
| 148  | [torch.mm](https://pytorch.org/docs/stable/generated/torch.mm.html?highlight=mm#torch.mm) | [paddle.matmul](https://www.paddlepaddle.org.cn/documentation/docs/zh/api/paddle/matmul_cn.html) |     [差异对比](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.mm.md)     |
| 149  | [torch.mv](https://pytorch.org/docs/stable/generated/torch.mv.html?highlight=mv#torch.mv) | 无对应实现                                                   | [组合实现](https://github.com/PaddlePaddle/X2Paddle/tree/develop/docs/pytorch_project_convertor/API_docs/ops/torch.mv.md)  |





***持续更新...***
