/**
 * Copyright 2020 Baidu Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import {Run, TimeMode} from '~/types';

export type {Range} from '~/types';

export type InvalidValue = 'nan' | 'inf';
export type Value = number | null;
type WallTime = number;
export type Step = number;
type Smoothed = number | null;
type Relative = number;

export type Dataset = [WallTime, Step, Value, Smoothed, Relative][];
export type ScalarDataset = [WallTime, Step, Value | InvalidValue][];

export {TimeMode as XAxis};
export enum SortingMethod {
    Default = 'default',
    Descending = 'descending',
    Ascending = 'ascending',
    Nearest = 'nearest'
}

export type TooltipData = {
    run: Run;
    item: Dataset[number];
    rawItem: ScalarDataset[number];
    min?: number;
    max?: number;
};
