// Copyright (c) 2019 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#pragma once
#include <string>
#include <vector>
#include <numeric>
#include "core/general-server/general_model_service.pb.h"
#include "core/general-server/op/general_infer_helper.h"
#include "core/predictor/tools/ocrtools/postprocess_op.h"
#include "core/predictor/tools/ocrtools/preprocess_op.h"
#include "paddle_inference_api.h"  // NOLINT

#include "opencv2/core.hpp"
#include "opencv2/imgcodecs.hpp"
#include "opencv2/imgproc.hpp"


namespace baidu {
namespace paddle_serving {
namespace serving {

class GeneralDetectionOp
    : public baidu::paddle_serving::predictor::OpWithChannel<GeneralBlob> {
  public:
    typedef std::vector<paddle::PaddleTensor> TensorVector;

    DECLARE_OP(GeneralDetectionOp);

    int inference();

  private:
    //config info
    bool use_gpu_ = false;
    int gpu_id_ = 0;
    int gpu_mem_ = 4000;
    int cpu_math_library_num_threads_ = 4;
    bool use_mkldnn_ = false;
    // pre-process
    PaddleOCR::ResizeImgType0 resize_op_;
    PaddleOCR::Normalize normalize_op_;
    PaddleOCR::Permute permute_op_;
    PaddleOCR::CrnnResizeImg resize_op_rec;

    bool use_tensorrt_ = false;
    bool use_fp16_ = false;
    // post-process
    PaddleOCR::PostProcessor post_processor_;

    //det config info
    int max_side_len_ = 960;

    double det_db_thresh_ = 0.3;
    double det_db_box_thresh_ = 0.5;
    double det_db_unclip_ratio_ = 2.0;

    std::vector<float> mean_det = {0.485f, 0.456f, 0.406f};
    std::vector<float> scale_det = {1 / 0.229f, 1 / 0.224f, 1 / 0.225f};
    bool is_scale_ = true;

    //rec config info
    std::vector<std::string> label_list_;
    std::vector<float> mean_rec = {0.5f, 0.5f, 0.5f};
    std::vector<float> scale_rec = {1 / 0.5f, 1 / 0.5f, 1 / 0.5f};
    cv::Mat GetRotateCropImage(const cv::Mat &srcimage,
                              std::vector<std::vector<int>> box);
    cv::Mat Base2Mat(std::string &base64_data);
    std::string base64Decode(const char* Data, int DataByte);
    std::vector<std::vector<std::vector<int>>> boxes;
};

}  // namespace serving
}  // namespace paddle_serving
}  // namespace baidu
