# Request Cache

本文主要介绍请求缓存功能及实现原理。

服务中请求由张量tensor、结果名称fetch_var_names、调试开关profile_server、标识码log_id组成，预测结果包含输出张量等。这里缓存会保存请求与结果的键值对。当请求命中缓存时，服务不会执行模型预测，而是会直接从缓存中提取结果。对于某些特定场景而言，这能显著降低请求耗时。

缓存可以通过设置`--request_cache_size`来开启。该标志默认为0，即不开启缓存。当设置非零值时，服务会以设置大小为存储上限开启缓存。这里设置的内存单位为字节。注意，如果设置`--request_cache_size`为0是不能开启缓存的。

缓存中的键为64位整形数，是由请求中的tensor和fetch_var_names数据生成的128位哈希值。如果请求命中，那么对应的处理结果会提取出来用于构建响应数据。如果请求没有命中，服务则会执行模型预测，在返回结果的同时将处理结果放入缓存中。由于缓存设置了存储上限，因此需要淘汰机制来限制缓存容量。当前，服务采用了最近最少使用（LRU）机制用于淘汰缓存数据。

## 注意事项

 - 只有预测成功的请求会进行缓存。如果请求失败或者在预测过程中返回错误，则处理结果不会缓存。
 - 缓存是基于请求数据的哈希值实现。因此，可能会出现两个不同的请求生成了相同的哈希值即哈希碰撞，这时服务可能会返回错误的响应数据。哈希值为64位数据，发生哈希碰撞的可能性较小。
 - 不论使用同步模式还是异步模式，均可以正常使用缓存功能。
