# Serving介绍、概述

Paddle Serving 是飞桨官方推荐的服务化部署框架，围绕 AI 落地的最后一公里提供专业、可靠、易用的在线模型服务框架。

## 主要特性
- 支持深度学习平台：支持 Paddle 框架训练模型，其他机器学习平台（Caffe、TensorFlow、ONNX、PyTorch）可通过 x2paddle 工具迁移模型。
- 支持多种网络协议：HTTP、gRPC、bRPC等多种协议。
- 支持多种语言 SDK：C++、Python、Java。
- 适配多种计算硬件：x86(Intel) CPU、ARM CPU、Nvidia GPU、昆仑 XPU、华为昇腾 310/910、海光 DCU、Nvidia Jetson 等多种硬件。
- 部署平台：支持 Docker 和 Kubernetes 云端部署，提供多种环境的 Docker 开发镜像和云端部署案例。
- 具有高性能设计：基于有向无环图（DAG）的异步流水线构建高性能服务化推理框架，具有多模型组合、异步调度、并发推理、动态批量和多卡多流等设计。
- 提供模型安全部署解决方案：加密模型部署、鉴权校验、HTTPs 安全网关，并在实际项目中应用。
- 提供大规模稀疏参数模型服务化部署方案：如推荐、广告等场景，具有高性能、大批量在线查询、离线增量版本更新、多版本管理和多表横向扩展能力。
- 提供丰富的经典模型示例：如 PaddleOCR、PaddleClas、PaddleDetection、PaddleSeg、PaddleNLP、PaddleRec 等套件，共计40+个预训练精品模型，更多模型持续扩展。

## 开发流程

**一.环境安装**

根据计算硬件、操作系统和软件驱动版本等环境差异，要选择正确的安装程序。提供多种系统环境安装、pip 程序安装和源码编译安装三种方案，安装完成后可使用环境检查命令验证。

#### 1.标准环境安装方案，请参考 [标准环境安装]()
#### 2.使用 pip 安装，请参考 [使用 pip 安装]()
#### 3.源码编译安装，请参考 [源码编译]()
#### 4.安装环境检查，请参考 [环境检查]()

**二.快速开发**

环境安装完成后，参考二种模型开发示例快速开发程序，更多模型示例请参考 [模型库]()。

#### 1.基于 C++ Serving 的单模型 Resnet_v2_50 部署示例，请参考[Resnet_v2_50]()
#### 2.基于 Python Pipeline 多模型组合 OCR_v2 部署示例，请参考[OCR]()

**三.服务部署**

经过开发和测试后，程序要在服务器上部署，Paddle Serving 提供基于 Kubernetes 集群部署案例，请参考 [Kubernetes 集群部署]()

多个服务入口安全网关部署，请参考 [安全网关]()


## 功能说明

**一.基础功能**

本章节系统介绍 Paddle Serving 提供的基础功能，每种功能的使用方法和功能选项，详情请参考 [基础功能]()

**二.进阶 C++ Serving**

本章节详细介绍 C++ Serving 的多种高级功能特性，以及设计方案、使用方法和性能调优等，详情请参考 [进阶 C++ Serving]()

**三.进阶 Python Pipeline**

本章节详细介绍 Python Pipeline 的多种高级功能特性，以及设计方案、使用方法和性能调优等，详情请参考 [进阶 Python Pipeline]()

**四.大规模稀疏参数索引服务**

本章节介绍稀疏参数索引场景，如推荐、广告系统中大规模 Embedding 查询的设计与使用方案，详情请参考 [大规模稀疏参数索引服务]()

