# PaddleX GUI使用教程

**第一步：准备数据**

在开始模型训练前，您需要根据不同的任务类型，将数据标注为相应的格式。目前PaddleX支持【图像分类】、【目标检测】、【语义分割】、【实例分割】四种任务类型。不同类型任务的数据处理方式可查看[数据标注方式](https://paddlex.readthedocs.io/zh_CN/latest/appendix/datasets.html)。

 

**第二步：导入我的数据集**

①数据标注完成后，您需要根据不同的任务，将数据和标注文件，按照客户端提示更名并保存到正确的文件中。

②在客户端新建数据集，选择与数据集匹配的任务类型，并选择数据集对应的路径，将数据集导入。

![](images/datasets1.jpg)

③选定导入数据集后，客户端会自动校验数据及标注文件是否合规，校验成功后，您可根据实际需求，将数据集按比例划分为训练集、验证集、测试集。

④您可在「数据分析」模块按规则预览您标注的数据集，双击单张图片可放大查看。

![](images/dataset2.jpg)

**第三步：创建项目**

① 在完成数据导入后，您可以点击「新建项目」创建一个项目。

② 您可根据实际任务需求选择项目的任务类型，需要注意项目所采用的数据集也带有任务类型属性，两者需要进行匹配。

![](images/project3.jpg)



**第四步：项目开发**

① **数据选择**：项目创建完成后，您需要选择已载入客户端并校验后的数据集，并点击下一步，进入参数配置页面。

![](images/project1.jpg)

② **参数配置**：主要分为**模型参数**、**训练参数**、**优化策略**三部分。您可根据实际需求选择模型结构、骨架网络及对应的训练参数、优化策略，使得任务效果最佳。

![](images/project2.jpg)

参数配置完成后，点击启动训练，模型开始训练并进行效果评估。

③ **训练可视化**：在训练过程中，您可通过VisualDL查看模型训练过程参数变化、日志详情，及当前最优的训练集和验证集训练指标。模型在训练过程中通过点击"中止训练"随时中止训练过程。

![](images/visualization1.jpg)

模型训练结束后，可选择进入『模型剪裁分析』或者直接进入『模型评估』。

![](images/visualization2.jpg)

④ **模型裁剪**：如果开发者希望减少模型的体积、计算量，提升模型在设备上的预测性能，可以采用PaddleX提供的模型裁剪策略。裁剪过程将对模型各卷积层的敏感度信息进行分析，根据各参数对模型效果的影响进行不同比例的裁剪，再进行精调训练获得最终裁剪后的模型。

![](images/visualization3.jpg)

⑤ **模型评估**：在模型评估页面，您可查看训练后的模型效果。评估方法包括混淆矩阵、精度、召回率等。

![](images/visualization4.jpg)

您还可以选择『数据集切分』时留出的『测试数据集』或从本地文件夹中导入一张/多张图片，将训练后的模型进行测试。根据测试结果，您可决定是否将训练完成的模型保存为预训练模型并进入模型发布页面，或返回先前步骤调整参数配置重新进行训练。

![](images/visualization5.jpg)



**第五步：模型发布**

当模型效果满意后，您可根据实际的生产环境需求，选择将模型发布为需要的版本。

![](images/publish.jpg)





**如果您有任何问题或建议，欢迎以issue的形式，或加入PaddleX官方QQ群（1045148026）直接反馈您的问题和需求**

![](images/QR.jpg)
