# 常见问题

## 1. 训练参数如何调整
> 参考[参数调整文档](appendix/parameters.md)

## 2. 训练过程因显存不够出错

> 通过使用在终端`nvidia-smi`命令，查看GPU是否被其它任务占用，尝试清除其它任务；  
> 调低训练时的`batch_size`参数，从而降低显存的要求，注意需等比例调低`learning_rate`等参数；
> 选用更小的模型或backbone。

## 3. 是否有更小的模型，适用于更低配置的设备上运行
> 可以使用模型裁剪，参考文档[模型裁剪使用教程](slim/prune.md)，通过调整裁剪参数，可以控制模型裁剪后的大小，在实际实验中，如VOC检测数据，使用yolov3-mobilenet，原模型大小为XXM，裁剪后为XX M，精度基本保持不变

## 4. 如何配置训练时GPU的卡数
> 通过在终端export环境变量，或在Python代码中设置，可参考文档[CPU/多卡GPU训练](gpu_configure.md)

## 5. 想将之前训练的模型参数上继续训练
> 在训练调用`train`接口时，将`pretrain_weights`设为之前的模型保存路径即可


## 6. PaddleX保存的模型分为正常训练过程中产生、裁剪训练产生、导出为部署模型和量化保存这么多种，有什么差别，怎么区分

**不同模型的功能差异**

>1.正常模型训练保存  
>
>>模型在正常训练过程，每间隔n个epoch保存的模型目录，模型可作为预训练模型参数，可使用PaddleX加载预测、或导出部署模型  

>2.裁剪训练保存  
>
>>模型在裁剪训练过程，每间隔n个epoch保存的模型目录，模型不可作为预训练模型参数，可使用PaddleX加载预测、或导出部署模型  

>3.导出部署模型  
>
>>为了模型在服务端部署，导出的模型目录，不可作为预训练模型参数，可使用PaddleX加载预测

>4.量化保存模型  
>
>>为了提升模型预测速度，将模型参数进行量化保存的模型目录，模型不可作为预训练模型参数，可使用PaddleX加载预测  

**区分方法**  
>> 通过模型目录下model.yml文件中`status`字段来区别不同的模型类型, 'Normal'、'Prune'、'Infer'、'Quant'分别表示正常模型训练保存、裁剪训练保存、导出的部署模型、量化保存模型


## 7. 模型训练需要太久时间，或者训练速度太慢，怎么提速
> 1.模型训练速度与用户选定的模型大小，和设定的`batch_size`相关，模型大小可直接参考[模型库](model_zoo.md)中的指标，一般而言，模型越大，训练速度就越慢；  

> 2.在模型速度之外，模型训练完成所需的时间又与用户设定的`num_epochs`迭代轮数相关，用户可以通过观察模型在验证集上的指标来决定是否提示结束掉训练进程（训练时设定`save_interval_epochs`参数，训练过程会每间隔`save_interval_epochs`轮数在验证集上计算指标，并保存模型）；  

## 8. 如何设定迭代的轮数
> 1. 用户自行训练时，如不确定迭代的轮数，可以将轮数设高一些，同时注意设置`save_interval_epochs`，这样模型迭代每间隔相应轮数就会在验证集上进行评估和保存，可以根据不同轮数模型在验证集上的评估指标，判断模型是否已经收敛，若模型已收敛，可以自行结束训练进程
>
## 9. 只有CPU，没有GPU，如何提升训练速度
> 当没有GPU时，可以根据自己的CPU配置，选择是否使用多CPU进行训练，具体配置方式可以参考文档[多卡CPU/GPU训练](gpu_configure.md)
>
## 10. 电脑不能联网，训练时因为下载预训练模型失败，如何解决
> 可以预先通过其它方式准备好预训练模型，然后训练时自定义`pretrain_weights`即可，可参考文档[无联网模型训练](how_to_offline_run.md)

## 11. 每次训练新的模型，都需要重新下载预训练模型，怎样可以下载一次就搞定
> 1.可以按照9的方式来解决这个问题  
> 2.每次训练前都设定`paddlex.pretrain_dir`路径，如设定`paddlex.pretrain_dir='/usrname/paddlex`，如此下载完的预训练模型会存放至`/usrname/paddlex`目录下，而已经下载在该目录的模型也不会再次重复下载
