# Copyright (c) 2020  PaddlePaddle Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
import sys
sys.path.append("../")
import os
import unittest
import paddle
import paddle.fluid as fluid
import paddle.dataset.mnist as reader
from paddleslim.common import get_distribution, pdf
sys.path.append("../demo")
from models import MobileNet


class TestAnalysisHelper(unittest.TestCase):
    def get_model(self):
        image = fluid.layers.data(
            name='image', shape=[1, 28, 28], dtype='float32')
        label = fluid.layers.data(name='label', shape=[1], dtype='int64')
        train_loader = fluid.io.DataLoader.from_generator(
            feed_list=[image, label],
            capacity=512,
            use_double_buffer=True,
            iterable=True)
        model = MobileNet()
        out = model.net(input=image, class_dim=10)
        cost = fluid.layers.cross_entropy(input=out, label=label)
        avg_cost = fluid.layers.mean(x=cost)
        startup_prog = fluid.default_startup_program()
        train_prog = fluid.default_main_program()
        return startup_prog, train_prog, train_loader

    def test_analysishelper(self):
        startup_prog, train_prog, train_loader = self.get_model()
        place = fluid.CUDAPlace(0) if fluid.is_compiled_with_cuda(
        ) else fluid.CPUPlace()
        train_reader = reader.train()
        train_reader = paddle.fluid.io.batch(train_reader, batch_size=64)
        train_loader.set_sample_list_generator(train_reader, place)
        exe = fluid.Executor(place)
        exe.run(startup_prog)
        var_names = [
            var.name for var in list(train_prog.list_vars())
            if 'generated_var' not in var.name and '@GRAD' not in var.name
        ][:50]
        var_dist = get_distribution(train_prog, var_names, exe, train_loader)
        pdf(var_dist, pdf_save_dir='var_dist_pdf')

        # test get_distribution
        self.assertTrue(isinstance(var_dist, dict))
        # test pdf
        self.assertTrue(os.path.exists('./var_dist_pdf'))


if __name__ == '__main__':
    unittest.main()
