import logging
import numpy as np
from ..common import get_logger
_logger = get_logger(__name__, level=logging.INFO)


def pact_thres(var_dist, q=100):
    """
    Compute the qth percentile threshold of the data in var_dist.

    Args:
        var_dist(dict): numpy array of variables distribution.
        q(float): Percentile to compute which must be between 0 and 100 inclusive. Default is 100.

    Returns:
        dict: the qth percentile of the array element in var_dist.
    """
    var_percentile = {}
    for var_name in var_dist.keys():
        var = var_dist[var_name]
        var = var.flatten()
        var = np.abs(var)
        try:
            var_percentile[var_name] = np.percentile(var, q)
        except:
            _logger.info('{} is empty in this program'.format(var_name))
    return var_percentile
