/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.paddle.lite;

import com.baidu.paddle.lite.ConfigBase;
import com.baidu.paddle.lite.CxxConfig;
import com.baidu.paddle.lite.MobileConfig;
import com.baidu.paddle.lite.PaddleLiteInitializer;
import com.baidu.paddle.lite.Tensor;

public class PaddlePredictor {
    private long cppPaddlePredictorPointer;

    public PaddlePredictor(ConfigBase configBase) {
        this.init(configBase);
    }

    public static PaddlePredictor createPaddlePredictor(ConfigBase configBase) {
        PaddlePredictor paddlePredictor = new PaddlePredictor(configBase);
        return paddlePredictor.cppPaddlePredictorPointer == 0L ? null : paddlePredictor;
    }

    public Tensor getInput(int n) {
        long l = this.getInputCppTensorPointer(n);
        return l == 0L ? null : new Tensor(l, false, this);
    }

    public Tensor getOutput(int n) {
        long l = this.getOutputCppTensorPointer(n);
        return l == 0L ? null : new Tensor(l, true, this);
    }

    public Tensor getTensor(String string) {
        long l = this.getCppTensorPointerByName(string);
        return l == 0L ? null : new Tensor(l, true, this);
    }

    public native boolean run();

    public native String getVersion();

    public native boolean saveOptimizedModel(String var1);

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    protected boolean init(ConfigBase configBase) {
        if (configBase instanceof CxxConfig) {
            this.cppPaddlePredictorPointer = this.newCppPaddlePredictor((CxxConfig)configBase);
        } else if (configBase instanceof MobileConfig) {
            this.cppPaddlePredictorPointer = this.newCppPaddlePredictor((MobileConfig)configBase);
        } else {
            throw new IllegalArgumentException("Not supported PaddleLite Config type");
        }
        return this.cppPaddlePredictorPointer != 0L;
    }

    protected boolean clear() {
        boolean bl = false;
        if (this.cppPaddlePredictorPointer != 0L) {
            bl = this.deleteCppPaddlePredictor(this.cppPaddlePredictorPointer);
            this.cppPaddlePredictorPointer = 0L;
        }
        return bl;
    }

    private native long getInputCppTensorPointer(int var1);

    private native long getOutputCppTensorPointer(int var1);

    private native long getCppTensorPointerByName(String var1);

    private native long newCppPaddlePredictor(CxxConfig var1);

    private native long newCppPaddlePredictor(MobileConfig var1);

    private native boolean deleteCppPaddlePredictor(long var1);

    static {
        PaddleLiteInitializer.init();
    }
}

