// Copyright (c) 2019 PaddlePaddle Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


#include <glog/logging.h>

#include "preprocessor.h"
#include "preprocessor_seg.h"


namespace PaddleSolution {

    std::shared_ptr<ImagePreProcessor> create_processor(
                           const std::string& conf_file) {
        auto config = std::make_shared<PaddleSolution::
                        PaddleSegModelConfigPaser>();
        if (!config->load_config(conf_file)) {
            LOG(FATAL) << "fail to laod conf file [" << conf_file << "]";
            return nullptr;
        }

        if (config->_pre_processor == "SegPreProcessor") {
            auto p = std::make_shared<SegPreProcessor>();
            if (!p->init(config)) {
                return nullptr;
            }
            return p;
        }

        LOG(FATAL) << "unknown processor_name [" << config->_pre_processor
                   << "]";

        return nullptr;
    }
}  // namespace PaddleSolution
