/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.paddle.lite;

public class Place {
    private TargetType target;
    private PrecisionType precision;
    private DataLayoutType layout;
    private int device;

    public Place() {
        this.target = TargetType.UNKNOWN;
        this.precision = PrecisionType.UNKNOWN;
        this.layout = DataLayoutType.UNKNOWN;
        this.device = 0;
    }

    public Place(TargetType targetType) {
        this(targetType, PrecisionType.FLOAT);
    }

    public Place(TargetType targetType, PrecisionType precisionType) {
        this(targetType, precisionType, DataLayoutType.NCHW);
    }

    public Place(TargetType targetType, PrecisionType precisionType, DataLayoutType dataLayoutType) {
        this(targetType, precisionType, dataLayoutType, 0);
    }

    public Place(TargetType targetType, PrecisionType precisionType, DataLayoutType dataLayoutType, int n) {
        this.target = targetType;
        this.precision = precisionType;
        this.layout = dataLayoutType;
        this.device = n;
    }

    public boolean isValid() {
        return this.target != TargetType.UNKNOWN && this.precision != PrecisionType.UNKNOWN && this.layout != DataLayoutType.UNKNOWN;
    }

    public TargetType getTarget() {
        return this.target;
    }

    public void setTarget(TargetType targetType) {
        this.target = targetType;
    }

    public PrecisionType getPrecision() {
        return this.precision;
    }

    public void setPrecision(PrecisionType precisionType) {
        this.precision = precisionType;
    }

    public DataLayoutType getLayout() {
        return this.layout;
    }

    public void setLayout(DataLayoutType dataLayoutType) {
        this.layout = dataLayoutType;
    }

    public int getDevice() {
        return this.device;
    }

    public void setDevice(int n) {
        this.device = n;
    }

    public int getTargetInt() {
        return this.target.value;
    }

    public int getPrecisionInt() {
        return this.precision.value;
    }

    public int getDataLayoutInt() {
        return this.layout.value;
    }

    public static enum DataLayoutType {
        UNKNOWN(0),
        NCHW(1),
        NHWC(3),
        ANY(2);

        public final int value;

        private DataLayoutType(int n2) {
            this.value = n2;
        }
    }

    public static enum PrecisionType {
        UNKNOWN(0),
        FLOAT(1),
        INT8(2),
        FP16(5),
        INT32(3),
        ANY(4),
        BOOL(6);

        public final int value;

        private PrecisionType(int n2) {
            this.value = n2;
        }
    }

    public static enum TargetType {
        UNKNOWN(0),
        HOST(1),
        X86(2),
        CUDA(3),
        ARM(4),
        OPEN_CL(5),
        FPGA(7),
        NPU(8),
        ANY(6);

        public final int value;

        private TargetType(int n2) {
            this.value = n2;
        }
    }
}

