import numpy as np
import os
import sys
import paddle
import paddle.fluid as fluid
import threading
import time
import config
from paddle.fluid.incubate.fleet.parameter_server.pslib import fleet
from paddle.fluid.incubate.fleet.utils.fleet_util import FleetUtil
from paddle.fluid.incubate.fleet.utils.hdfs import HDFSClient
from model_new import Model
from model_new_jc import ModelJoinCommon
import util
from util import *

fleet_util = FleetUtil()

def time_prefix_str():
    return "\n" + time.strftime("%Y-%m-%d %H:%M:%S",time.localtime()) + "[0]:"

auc_record = {}
def check_auc_ok(auc_label, auc_log, auc_alarm):
    auc_datas = auc_log.split(' AUC=')
    if len(auc_datas) < 2:
        return True
    if auc_label not in auc_record:
        auc_record[auc_label] = 0.0
    auc = float(auc_datas[1].split(' ')[0])
    if auc < auc_record[auc_label] and auc < auc_alarm:
        fleet_util.rank0_print("label:%s, auc:%s, check bad" % (auc_label, auc)) 
        return False
    auc_record[auc_label] = auc
    fleet_util.rank0_print("label:%s, auc:%s, check ok" % (auc_label, auc)) 
    return True

def create_model(slot_file, slot_common_file, all_slot_file):
    join_common_model = ModelJoinCommon(slot_file, slot_common_file, all_slot_file, 20)
    update_model = Model(slot_file, all_slot_file, False, 0, True)
    with open("join_common_main_program.pbtxt", "w") as fout:
        print >> fout, join_common_model._train_program
    with open("join_common_startup_program.pbtxt", "w") as fout:
        print >> fout, join_common_model._startup_program
    with open("update_main_program.pbtxt", "w") as fout:
        print >> fout, update_model._train_program
    with open("update_startup_program.pbtxt", "w") as fout:
        print >> fout, update_model._startup_program
    return [join_common_model, update_model]

def create_dataset(use_var_list, my_filelist):
    dataset = fluid.DatasetFactory().create_dataset(config.dataset_type)
    dataset.set_batch_size(config.batch_size)
    dataset.set_thread(config.thread_num)
    dataset.set_hdfs_config(config.fs_name, config.fs_ugi)
    dataset.set_pipe_command(config.pipe_command)
    dataset.set_filelist(my_filelist)
    dataset.set_use_var(use_var_list)
    #dataset.set_fleet_send_sleep_seconds(2)
    #dataset.set_fleet_send_batch_size(80000)
    return dataset

def hdfs_ls(path):
    configs = {
	"fs.default.name": config.fs_name,
	"hadoop.job.ugi": config.fs_ugi
    }
    hdfs_client = HDFSClient("$HADOOP_HOME", configs)
    filelist = []
    for i in path:
        cur_path = hdfs_client.ls(i)
        if config.fs_name.startswith("hdfs:"):
            cur_path = ["hdfs:" + j for j in cur_path]
        elif config.fs_name.startswith("afs:"):
            cur_path = ["afs:" + j for j in cur_path]
        filelist += cur_path
    return filelist

def get_avg_cost_mins(value):
    t1 = time.time()
    local_cost = np.array([value])
    global_cost = np.copy(local_cost) * 0
    t2 = time.time()
    fleet._role_maker._node_type_comm.Allreduce(local_cost, global_cost)
    t3 = time.time()
    avg_cost = float(global_cost[0]) / fleet.worker_num()
    avg_cost /= 60.0
    t4 = time.time()
    tc = (t2 - t1 + t4 - t3) / 60.0
    tb = (t3 - t2) / 60.0
    fleet_util.rank0_print("get_avg_cost_mins calc time %s barrier time %s" % (tc, tb))
    return avg_cost

def get_max_cost_mins(value):
    from mpi4py import MPI
    local_cost = np.array([value])
    global_cost = np.copy(local_cost) * 0
    fleet._role_maker._node_type_comm.Allreduce(local_cost, global_cost, op=MPI.MAX)
    fleet_util.rank0_print("max train time %s mins" % (float(global_cost[0]) / 60.0))

def get_min_cost_mins(value):
    from mpi4py import MPI
    local_cost = np.array([value])
    global_cost = np.copy(local_cost) * 0
    fleet._role_maker._node_type_comm.Allreduce(local_cost, global_cost, op=MPI.MIN)
    fleet_util.rank0_print("min train time %s mins" % (float(global_cost[0]) / 60.0))

def get_data_max(value):
    from mpi4py import MPI
    local_cost = np.array([value])
    global_cost = np.copy(local_cost) * 0
    fleet._role_maker._node_type_comm.Allreduce(local_cost, global_cost, op=MPI.MAX)
    fleet_util.rank0_print("data size max %s" % global_cost[0])

def get_data_min(value):
    from mpi4py import MPI
    local_cost = np.array([value])
    global_cost = np.copy(local_cost) * 0
    fleet._role_maker._node_type_comm.Allreduce(local_cost, global_cost, op=MPI.MIN)
    fleet_util.rank0_print("data size min %s" % global_cost[0])

def clear_metrics(fleet_util, model, scope):
    fleet_util.set_zero(model.stat_pos.name, scope)
    fleet_util.set_zero(model.stat_neg.name, scope)
    fleet_util.set_zero(model.batch_stat_pos.name, scope)
    fleet_util.set_zero(model.batch_stat_neg.name, scope)
    fleet_util.set_zero(model.abserr.name, scope, param_type="float32")
    fleet_util.set_zero(model.sqrerr.name, scope, param_type="float32")
    fleet_util.set_zero(model.prob.name, scope, param_type="float32")
    fleet_util.set_zero(model.q.name, scope, param_type="float32")
    fleet_util.set_zero(model.pos.name, scope, param_type="float32")
    fleet_util.set_zero(model.total.name, scope, param_type="float32")

def clear_metrics_2(fleet_util, model, scope):
    fleet_util.set_zero(model.join_stat_pos.name, scope)
    fleet_util.set_zero(model.join_stat_neg.name, scope)
    fleet_util.set_zero(model.join_batch_stat_pos.name, scope)
    fleet_util.set_zero(model.join_batch_stat_neg.name, scope)
    fleet_util.set_zero(model.join_abserr.name, scope, param_type="float32")
    fleet_util.set_zero(model.join_sqrerr.name, scope, param_type="float32")
    fleet_util.set_zero(model.join_prob.name, scope, param_type="float32")
    fleet_util.set_zero(model.join_q.name, scope, param_type="float32")
    fleet_util.set_zero(model.join_pos.name, scope, param_type="float32")
    fleet_util.set_zero(model.join_total.name, scope, param_type="float32")

    fleet_util.set_zero(model.common_stat_pos.name, scope)
    fleet_util.set_zero(model.common_stat_neg.name, scope)
    fleet_util.set_zero(model.common_batch_stat_pos.name, scope)
    fleet_util.set_zero(model.common_batch_stat_neg.name, scope)
    fleet_util.set_zero(model.common_abserr.name, scope, param_type="float32")
    fleet_util.set_zero(model.common_sqrerr.name, scope, param_type="float32")
    fleet_util.set_zero(model.common_prob.name, scope, param_type="float32")
    fleet_util.set_zero(model.common_q.name, scope, param_type="float32")
    fleet_util.set_zero(model.common_pos.name, scope, param_type="float32")
    fleet_util.set_zero(model.common_total.name, scope, param_type="float32")

def save_delta(day, pass_index, xbox_base_key, cur_path, exe, scope_join, scope_common, scope_update, join_model,
               join_common_model, update_model, join_save_params, common_save_params, update_save_params, monitor_data):
    stdout_str = ""
    fleet_util.rank0_print("begin save delta model")
    begin = time.time()
    if pass_index == -1:
        fleet_util.save_xbox_base_model(config.output_path, day)
    else:
        fleet_util.save_delta_model(config.output_path, day, pass_index)
    end = time.time()
    fleet_util.save_paddle_params(exe, scope_join, join_model._train_program, "paddle_dense.model.0",
                                  config.output_path, day, pass_index, config.fs_name, config.fs_ugi,
                                  var_names=join_save_params)
    fleet_util.save_paddle_params(exe, scope_common, join_common_model._train_program, "paddle_dense.model.1",
                                  config.output_path, day, pass_index, config.fs_name, config.fs_ugi,
                                  var_names=common_save_params)
    fleet_util.save_paddle_params(exe, scope_update, update_model._train_program, "paddle_dense.model.2",
                                  config.output_path, day, pass_index, config.fs_name, config.fs_ugi,
                                  var_names=update_save_params)
    log_str = "end save delta cost %s min" % ((end - begin) / 60.0)
    fleet_util.rank0_print(log_str)
    stdout_str += time_prefix_str() + log_str
    fleet_util.rank0_print("begin save cache")
    begin = time.time()
    if pass_index == -1:
        key_num = fleet_util.save_cache_base_model(config.output_path, day)
    else:
        key_num = fleet_util.save_cache_model(config.output_path, day, pass_index)
    fleet_util.write_cache_donefile(config.output_path, day, pass_index, key_num, config.fs_name, config.fs_ugi)
    end = time.time()
    log_str = "end save cache cost %s min, key_num=%s" % ((end - begin) / 60.0, key_num)
    fleet_util.rank0_print(log_str)
    stdout_str += time_prefix_str() + log_str
    write_xbox_donefile(day, pass_index, xbox_base_key, ",".join(cur_path), monitor_data=monitor_data)
    return stdout_str

if __name__ == "__main__":

    place = fluid.CPUPlace()
    exe = fluid.Executor(place)
    fleet.init(exe)

    slot_file = "slot/slot"
    slot_common_file = "slot/slot_common"
    all_slot_file = "all_slot.dict"

    join_common_model, update_model = create_model(slot_file, slot_common_file, all_slot_file)

    scope2 = fluid.Scope()
    scope3 = fluid.Scope()

    adjust_ins_weight = { "need_adjust" : True, "nid_slot" : "6002", "nid_adjw_threshold" : 1000, "nid_adjw_ratio": 20,
                          "ins_weight_slot": update_model.ins_weight.name }

    thread_stat_var_names = []
    thread_stat_var_names.append(join_common_model.join_stat_pos.name)
    thread_stat_var_names.append(join_common_model.join_stat_neg.name)
    thread_stat_var_names.append(join_common_model.join_sqrerr.name)
    thread_stat_var_names.append(join_common_model.join_abserr.name)
    thread_stat_var_names.append(join_common_model.join_prob.name)
    thread_stat_var_names.append(join_common_model.join_q.name)
    thread_stat_var_names.append(join_common_model.join_pos.name)
    thread_stat_var_names.append(join_common_model.join_total.name)

    thread_stat_var_names.append(join_common_model.common_stat_pos.name)
    thread_stat_var_names.append(join_common_model.common_stat_neg.name)
    thread_stat_var_names.append(join_common_model.common_sqrerr.name)
    thread_stat_var_names.append(join_common_model.common_abserr.name)
    thread_stat_var_names.append(join_common_model.common_prob.name)
    thread_stat_var_names.append(join_common_model.common_q.name)
    thread_stat_var_names.append(join_common_model.common_pos.name)
    thread_stat_var_names.append(join_common_model.common_total.name)

    thread_stat_var_names.append(update_model.stat_pos.name)
    thread_stat_var_names.append(update_model.stat_neg.name)
    thread_stat_var_names.append(update_model.sqrerr.name)
    thread_stat_var_names.append(update_model.abserr.name)
    thread_stat_var_names.append(update_model.prob.name)
    thread_stat_var_names.append(update_model.q.name)
    thread_stat_var_names.append(update_model.pos.name)
    thread_stat_var_names.append(update_model.total.name)
    
    thread_stat_var_names = list(set(thread_stat_var_names))


    adam = fluid.optimizer.Adam(learning_rate=0.000005)
    adam = fleet.distributed_optimizer(adam, strategy={"use_cvm" : True, "adjust_ins_weight" : adjust_ins_weight, "scale_datanorm" : 1e-4, "dump_slot": True, "stat_var_names": thread_stat_var_names, "fleet_desc_file": "reqi_fleet_desc"})
    adam.minimize([join_common_model.joint_cost, update_model.avg_cost], [scope2, scope3])

    join_common_model._train_program._fleet_opt["program_configs"][str(id(join_common_model.joint_cost.block.program))]["push_sparse"] = []

    join_save_params = ["join.batch_size", "join.batch_sum", "join.batch_square_sum",
                        "join_0.w_0", "join_0.b_0", "join_1.w_0", "join_1.b_0", "join_2.w_0", "join_2.b_0",
                        "join_3.w_0", "join_3.b_0", "join_4.w_0", "join_4.b_0", "join_5.w_0", "join_5.b_0",
                        "join_6.w_0", "join_6.b_0", "join_7.w_0", "join_7.b_0"]
    common_save_params = ["common.batch_size", "common.batch_sum", "common.batch_square_sum",
                         "common_0.w_0", "common_0.b_0", "common_1.w_0", "common_1.b_0", "common_2.w_0", "common_2.b_0",
                         "common_3.w_0", "common_3.b_0", "common_4.w_0", "common_4.b_0", "common_5.w_0", "common_5.b_0",
                         "common_6.w_0", "common_6.b_0", "common_7.w_0", "common_7.b_0"]
    update_save_params = ["fc_0.w_0", "fc_0.b_0", "fc_1.w_0", "fc_1.b_0",
                           "fc_2.w_0", "fc_2.b_0", "fc_3.w_0", "fc_3.b_0",
                           "fc_4.w_0", "fc_4.b_0", "fc_5.w_0", "fc_5.b_0"]

    if fleet.is_server():
        fleet.run_server()
    elif fleet.is_worker():
        with fluid.scope_guard(scope3):
            exe.run(update_model._startup_program)
        with fluid.scope_guard(scope2):
            exe.run(join_common_model._startup_program)
        
        configs = {
            "fs.default.name": config.fs_name,
            "hadoop.job.ugi": config.fs_ugi
        }
        hdfs_client = HDFSClient("$HADOOP_HOME", configs)

        save_first_base = config.save_first_base
        path = config.train_data_path
        online_pass_interval = fleet_util.get_online_pass_interval(config.days, config.hours, config.split_interval, config.split_per_pass, False) 
        pass_per_day = len(online_pass_interval)
        last_day, last_pass, last_path, xbox_base_key = fleet_util.get_last_save_model(config.output_path, config.fs_name, config.fs_ugi)
        reqi = True if last_day != -1 else False

        if config.need_reqi_changeslot and config.reqi_dnn_plugin_day >= last_day and config.reqi_dnn_plugin_pass >= last_pass:
            util.reqi_changeslot(config.hdfs_dnn_plugin_path, join_save_params, common_save_params, update_save_params, scope2, scope3)
        fleet.init_worker()
        
        dataset = None
        next_dataset = None
        cur_path = None
        next_path = None
        start_train = False
        days = os.popen("echo -n " + config.days).read().split(" ")
        hours = os.popen("echo -n " + config.hours).read().split(" ")
        stdout_str = ""
        begin_days = {}
        for day_index in range(len(days)):
            day = days[day_index]
            if last_day != -1 and int(day) < last_day:
                continue
            for pass_index in range(1, pass_per_day + 1):
                dataset = next_dataset
                next_dataset = None
                cur_path = next_path
                next_path = None
                if (last_day != -1 and int(day) == last_day) and (last_pass != -1 and int(pass_index) < last_pass):
                    continue
                if reqi:
                    begin = time.time()
                    log_str = "going to load model %s" % last_path
                    fleet_util.rank0_print(log_str)
                    if config.need_reqi_changeslot and config.reqi_dnn_plugin_day >= last_day and config.reqi_dnn_plugin_pass >= last_pass:
                        fleet.load_one_table(0, last_path)
                    else:
                        fleet_util.load_fleet_model(last_path)

                    end = time.time()
                    log_str = "load model cost %s min" % ((end - begin) / 60.0)
                    fleet_util.rank0_print(log_str)
                    stdout_str += time_prefix_str() + log_str
                    reqi = False
                    if (last_day != -1 and int(day) == last_day) and (last_pass != -1 and int(pass_index) == last_pass):
                        continue

                #log_str = "===========going to train day/pass %s/%s===========" % (day, pass_index)
                        
                if begin_days.get(day) is None:
                    log_str = "======== BEGIN DAY:%s ========" % day
                    fleet_util.rank0_print(log_str)
                    stdout_str += time_prefix_str() + log_str
                    begin_days[day] = True

                log_str = "    ==== begin delta:%s ========" % pass_index
                fleet_util.rank0_print(log_str)
                stdout_str += time_prefix_str() + log_str

                if save_first_base:
                    log_str = "save_first_base=True"
                    fleet_util.rank0_print(log_str)
                    save_first_base = False
                    last_base_day, last_base_path, tmp_xbox_base_key = \
                        fleet_util.get_last_save_xbox_base(config.output_path, config.fs_name, config.fs_ugi)
                    if int(day) > last_base_day:
                        log_str = "going to save xbox base model"
                        fleet_util.rank0_print(log_str)
                        stdout_str += time_prefix_str() + log_str
                        xbox_base_key = int(time.time())
                        cur = []
                        for interval in online_pass_interval[pass_index - 1]:
                            for p in path:
                                cur.append(p + "/" + day + "/" + interval)
                        stdout_str += save_delta(day, -1, xbox_base_key, cur, exe, scope2, scope2, scope3,
                                                 join_common_model, join_common_model, update_model, 
                                                 join_save_params, common_save_params, update_save_params, "")
                    elif int(day) == last_base_day:
                        xbox_base_key = tmp_xbox_base_key
                        log_str = "xbox base model exists"
                        fleet_util.rank0_print(log_str)
                        stdout_str += time_prefix_str() + log_str
                    else:
                        log_str = "xbox base model exists"
                        fleet_util.rank0_print(log_str)
                        stdout_str += time_prefix_str() + log_str

                start_train = True
                train_begin = time.time()

                if dataset is not None:
                    begin = time.time()
                    dataset.wait_preload_done()
                    end = time.time()
                    log_str = "wait data preload done cost %s min" % ((end - begin) / 60.0)
                    fleet_util.rank0_print(log_str)
                    stdout_str += time_prefix_str() + log_str

                if dataset is None:
                    cur_pass = online_pass_interval[pass_index - 1]
                    cur_path = []
                    for interval in cur_pass:
                        for p in path:
                            cur_path.append(p + "/" + day + "/" + interval)
                    log_str = "data path: " + ",".join(cur_path)
                    fleet_util.rank0_print(log_str)
                    stdout_str += time_prefix_str() + log_str
                    for i in cur_path:
                        while not hdfs_client.is_exist(i + "/to.hadoop.done"):
                            fleet_util.rank0_print("wait for data ready: %s" % i)
                            time.sleep(config.check_exist_seconds)
                    my_filelist = fleet.split_files(hdfs_ls(cur_path))

                    dataset = create_dataset(join_common_model._all_slots, my_filelist)
                    fleet_util.rank0_print("going to load into memory")
                    begin = time.time()
                    dataset.load_into_memory()
                    end = time.time()
                    log_str = "load into memory done, cost %s min" % ((end - begin) / 60.0)
                    fleet_util.rank0_print(log_str)
                    stdout_str += time_prefix_str() + log_str

                fleet_util.rank0_print("going to global shuffle")
                begin = time.time()
                dataset.global_shuffle(fleet, config.shuffle_thread)
                end = time.time()
                log_str = "global shuffle done, cost %s min, data size %s" % ((end - begin) / 60.0, dataset.get_shuffle_data_size(fleet))
                fleet_util.rank0_print(log_str)
                stdout_str += time_prefix_str() + log_str
                get_data_max(dataset.get_shuffle_data_size())
                get_data_min(dataset.get_shuffle_data_size())

                if config.prefetch and (pass_index < pass_per_day or pass_index == pass_per_day and day_index < len(days) - 1):
                    if pass_index < pass_per_day:
                        next_pass = online_pass_interval[pass_index]
                        next_day = day
                    else:
                        next_pass = online_pass_interval[0]
                        next_day = days[day_index + 1]
                    next_path = []
                    for interval in next_pass:
                        for p in path:
                            next_path.append(p + "/" + next_day + "/" + interval)
                    next_data_ready = True
                    for i in next_path:
                        if not hdfs_client.is_exist(i + "/to.hadoop.done"):
                            next_data_ready = False
                            fleet_util.rank0_print("next data not ready: %s" % i)
                    if not next_data_ready:
                        next_dataset = None
                    else:
                        my_filelist = fleet.split_files(hdfs_ls(next_path))
                        next_dataset = create_dataset(join_common_model._all_slots, my_filelist)
                        log_str = "next pass data preload %s " % ",".join(next_path)
                        fleet_util.rank0_print(log_str)
                        stdout_str += time_prefix_str() + log_str
                        next_dataset.preload_into_memory(config.preload_thread)


                join_cost = 0
                common_cost = 0
                update_cost = 0
                monitor_data = ""

                with fluid.scope_guard(scope2):
                    fleet_util.rank0_print("Begin join + common pass")
                    begin = time.time()
                    exe.train_from_dataset(join_common_model._train_program,
                                           dataset,
                                           scope2,
                                           thread=config.join_common_thread,
                                           debug=False)
                    end = time.time()
                    avg_cost = get_avg_cost_mins(end - begin)
                    
                    fleet_util.rank0_print("avg train time %s mins" % avg_cost)

                    get_max_cost_mins(end - begin)
                    get_min_cost_mins(end - begin)

                    common_cost = avg_cost
                   
                    monitor_data = ""
                    log_str = print_global_metrics(scope2, join_common_model.join_stat_pos.name, join_common_model.join_stat_neg.name,
                                                   join_common_model.join_sqrerr.name, join_common_model.join_abserr.name,
                                                   join_common_model.join_prob.name,
                                                   join_common_model.join_q.name, join_common_model.join_pos.name,
                                                   join_common_model.join_total.name, "joining pass:")#"join pass:")
                    check_auc_ok("joining pass:", log_str, 0.79)
                    monitor_data += log_str
                    stdout_str += time_prefix_str() + "joining pass:"
                    stdout_str += time_prefix_str() + log_str

                    log_str = print_global_metrics(scope2, join_common_model.common_stat_pos.name, join_common_model.common_stat_neg.name,
                                                   join_common_model.common_sqrerr.name, join_common_model.common_abserr.name,
                                                   join_common_model.common_prob.name,
                                                   join_common_model.common_q.name, join_common_model.common_pos.name,
                                                   join_common_model.common_total.name, "common pass:")
                    check_auc_ok("common pass:", log_str, 0.70)
                    monitor_data += " " + log_str
                    stdout_str += time_prefix_str() + "common pass:"
                    stdout_str += time_prefix_str() + log_str
                    fleet_util.rank0_print("End join+common pass")
                    clear_metrics_2(fleet_util, join_common_model, scope2)

                if config.save_xbox_before_update and pass_index % config.save_delta_frequency == 0:
                    fleet_util.rank0_print("going to save delta model")
                    last_xbox_day, last_xbox_pass, last_xbox_path, _ = fleet_util.get_last_save_xbox(config.output_path,  config.fs_name, config.fs_ugi)
                    if int(day) < last_xbox_day or int(day) == last_xbox_day and int(pass_index) <= last_xbox_pass:
                        log_str = "delta model exists"
                        fleet_util.rank0_print(log_str)
                        stdout_str += time_prefix_str() + log_str
                    else:
                        stdout_str += save_delta(day, pass_index, xbox_base_key, cur_path, exe, scope2, scope2, scope3,
                                                 join_common_model, join_common_model, update_model,
                                                 join_save_params, common_save_params, update_save_params, monitor_data)

                with fluid.scope_guard(scope3):
                    fleet_util.rank0_print("Begin update pass")
                    begin = time.time()
                    exe.train_from_dataset(update_model._train_program,
                                           dataset,
                                           scope3,
                                           thread=config.update_thread,
                                           debug=False)
                    end = time.time()
                    avg_cost = get_avg_cost_mins(end - begin)

                    get_max_cost_mins(end - begin)
                    get_min_cost_mins(end - begin)

                    update_cost = avg_cost
                    
                    log_str = print_global_metrics(scope3, update_model.stat_pos.name, update_model.stat_neg.name,
                                                   update_model.sqrerr.name, update_model.abserr.name, update_model.prob.name,
                                                   update_model.q.name, update_model.pos.name, update_model.total.name,
                                                   "updating pass:")#"update pass:")
                    check_auc_ok("updating pass:", log_str, 0.79)
                    stdout_str += time_prefix_str() + "updating pass:"
                    stdout_str += time_prefix_str() + log_str
                    fleet_util.rank0_print("End update pass")
                    clear_metrics(fleet_util, update_model, scope3)

                begin = time.time()
                dataset.release_memory()
                end = time.time()
                fleet_util.rank0_print("release_memory cost %s min" % ((end - begin) / 60.0))

                if (pass_index % config.checkpoint_per_pass) == 0 and pass_index != pass_per_day:
                    begin = time.time()
                    fleet_util.save_model(config.output_path, day, pass_index)
                    fleet_util.write_model_donefile(config.output_path, day, pass_index, xbox_base_key, config.fs_name, config.fs_ugi)
                    end = time.time()
                    log_str = "save model cost %s min" % ((end - begin) / 60.0)
                    fleet_util.rank0_print(log_str)
                    stdout_str += time_prefix_str() + log_str
                if not config.save_xbox_before_update and pass_index % config.save_delta_frequency == 0:
                    fleet_util.rank0_print("going to save delta model")
                    last_xbox_day, last_xbox_pass, last_xbox_path, _ = fleet_util.get_last_save_xbox(config.output_path,  config.fs_name, config.fs_ugi)
                    if int(day) < last_xbox_day or int(day) == last_xbox_day and int(pass_index) <= last_xbox_pass:
                        log_str = "delta model exists"
                        fleet_util.rank0_print(log_str)
                        stdout_str += time_prefix_str() + log_str
                    else:
                        stdout_str += save_delta(day, pass_index, xbox_base_key, cur_path, exe, scope2, scope2, scope3,
                                                 join_common_model, join_common_model, update_model,
                                                 join_save_params, common_save_params, update_save_params, monitor_data)

                train_end = time.time()
                train_cost = (train_end - train_begin) / 60.0
                other_cost = train_cost - join_cost - common_cost - update_cost
                log_str = "finished train day %s pass %s time cost:%s min job time cost" \
                          ":[join:%s min][join_common:%s min][update:%s min][other:%s min]" \
                          % (day, pass_index, train_cost, join_cost, common_cost, update_cost, other_cost)
                fleet_util.rank0_print(log_str)
                stdout_str += time_prefix_str() + log_str

                if pass_index % config.write_stdout_frequency == 0:
                    write_stdout(stdout_str)
                    stdout_str = ""
            
            xbox_base_key = int(time.time())
            if not start_train:
                write_stdout(stdout_str)
                stdout_str = ""
                continue


            fleet_util.rank0_print("going to save batch model/base xbox model")
            last_base_day, last_base_path, _ = fleet_util.get_last_save_xbox_base(config.output_path, config.fs_name, config.fs_ugi)
            nextday = int(days[day_index + 1])
            if nextday <= last_base_day:
                log_str = "batch model/base xbox model exists"
                fleet_util.rank0_print(log_str)
                stdout_str += time_prefix_str() + log_str
            else:
                stdout_str += save_delta(nextday, -1, xbox_base_key, cur_path, exe, scope2, scope2, scope3,
                                         join_common_model, join_common_model, update_model,
                                         join_save_params, common_save_params, update_save_params, monitor_data)
                
                fleet_util.rank0_print("shrink table")
                begin = time.time()
                fleet.shrink_sparse_table()
                fleet.shrink_dense_table(0.98, scope=scope2, table_id=1)
                fleet.shrink_dense_table(0.98, scope=scope2, table_id=2)
                fleet.shrink_dense_table(0.98, scope=scope3, table_id=3)
                end = time.time()
                log_str = "shrink table done, cost %s min" % ((end - begin) / 60.0)
                fleet_util.rank0_print(log_str)
                stdout_str += time_prefix_str() + log_str

                begin = time.time()
                fleet_util.save_batch_model(config.output_path, nextday)
                fleet_util.write_model_donefile(config.output_path, nextday, -1, xbox_base_key, config.fs_name, config.fs_ugi)
                end = time.time()
                log_str = "save batch model cost %s min" % ((end - begin) / 60.0)
                fleet_util.rank0_print(log_str)
                stdout_str += time_prefix_str() + log_str
            write_stdout(stdout_str)
            stdout_str = ""
