# Paddle-TDM
本代码库提供了基于PaddlePaddle实现的TreeBased推荐搜索算法，主要包含以下组成：

- 基于fake数据集，适用于快速调试的paddle-tdm模型。主要用于理解paddle-tdm的设计原理，高效上手设计适合您的使用场景的模型。

以上内容将随paddle版本迭代不断更新，欢迎您关注该代码库。

## TDM设计思路

### 基本概念
TDM是为大规模推荐系统设计的、能承载任意先进模型来高效检索用户兴趣的推荐算法解决方案。TDM基于树结构，提出了一套对用户兴趣度量进行层次化建模与检索的方法论，使得系统能直接利高级深度学习模型在全库范围内检索用户兴趣。其基本原理是使用树结构对全库item进行索引，然后训练深度模型以支持树上的逐层检索，从而将大规模推荐中全库检索的复杂度由O(n)（n为所有item的量级）下降至O(log n)。

### 核心问题

1. 如何构建树结构？
2. 如何基于树结构做深度学习模型的训练？
3. 如何基于树及模型进行高效检索？

### PaddlePaddle的TDM方案

1. 树结构的数据，来源于各个业务的实际场景，构造方式各有不同，paddle-TDM一期暂不提供统一的树的构造流程，但会统一树构造好之后，输入paddle网络的数据组织形式。业务方可以使用任意工具构造自己的树，生成指定的数据格式，参与tdm网络训练。
2. 网络训练中，有三个核心问题:
   
   - 如何组网？答：paddle封装了大量的深度学习OP，用户可以根据需求设计自己的网络结构。
   - 训练数据如何组织？答：tdm的训练数据主要为：`user/query emb` 加 `item`的正样本，`item`需要映射到树的某个叶子节点。用户只需准备符合该构成的数据即可。负样本的生成，会基于用户提供的树结构，以及paddle提供的`tdm-sampler op`完成高效的负采样，并自动添加相应的label，参与tdm中深度学习模型的训练。
   - 大规模的数据与模型训练如何实现？答：基于paddle优秀的大规模参数服务器分布式能力，可以实现高效的分布式训练。基于paddle-fleet api，学习门槛极低，且可以灵活的支持增量训练，流式训练等业务需求。
3. 训练好模型后，可以基于paddle，将检索与打分等流程都融入paddle的组网中，生成inference_model与参数文件，基于PaddlePaddle的预测库或者PaddleLite进行快速部署与高效检索。
