
# Quick Start

PaddleGAN is a PaddlePaddle Generative Adversarial Network (GAN) development kit that provides a high-performance replication of a variety of classical networks with applications covering a wide range of areas such as image generation, style migration, ainimation driving, image/video super resolution and colorization.

This section will teach you how to quickly get started with PaddleGAN, using the  train and evaluate of the CycleGAN model on the Cityscapes dataset as an example.

Note that all model configuration files in PaddleGAN are available at [. /PaddleGAN/configs](https://github.com/PaddlePaddle/PaddleGAN/tree/develop/configs).

## Contents

* [Installation](#Installation)
* [Data preparation](#Data-preparation)
* [Training](#Trianing)
  * [Single Card Training](#Single-Card-Training)
    * [Parameters](#Parameters)
    * [Visualize Training](#Visualize-Training)
    * [Resume Training](#Resume-Training)
  * [Multi-Card Training](#Multi-Card-Training)
* [Evaluation](#Evaluation)

## Installation

For installation and configuration of the runtime environment, please refer to the [installation documentation](https://github.com/PaddlePaddle/PaddleGAN/blob/develop/docs/en_US/install.md) to complete the installation of PaddlePaddle and PaddleGAN.

In this demo, it is assumed that the user cloned and placed the code of PaddleGAN in the '/home/paddle' directory. The user executes the command operations in the '/home/paddle/PaddleGAN' directory.

## Data preparation

Prepare the Cityscapes dataset according to the [data preparation](https://github.com/PaddlePaddle/PaddleGAN/blob/develop/docs/en_US/data_prepare.md).

Download the Cityscapes dataset to ~/.cache/ppgan and softlink to PaddleGAN/data/ using the following script.

```
python data/download_cyclegan_data.py --name cityscapes
```
## Trianing

### 1. Single Card Training

 ```
 python -u tools/main.py --config-file configs/cyclegan_cityscapes.yaml
 ```

#### Parameters

* `--config-file (str)`: path to the config file. This is the configuration file used here for CycleGAN training on the Cityscapes dataset.

* The output logs, weights, and visualization results are saved by default in `. /output_dir`, which can be modified by the `output_dir` parameter in the configuration file:

  ```
  output_dir: output_dir
  ```

  <div align='center'>
    <img src='https://user-images.githubusercontent.com/48054808/122734130-65448b00-d2b0-11eb-9fc4-302f3e851115.png' width=60%>
  </div>

* The saved folder will automatically generate a new directory based on the model name and timestamp, with the following directory example.

```
output_dir
└── CycleGANModel-2020-10-29-09-21
    ├── epoch_1_checkpoint.pkl
    ├── log.txt
    └── visual_train
        ├── epoch001_fake_A.png
        ├── epoch001_fake_B.png
        ├── epoch001_idt_A.png
        ├── epoch001_idt_B.png
        ├── epoch001_real_A.png
        ├── epoch001_real_B.png
        ├── epoch001_rec_A.png
        ├── epoch001_rec_B.png
        ├── epoch002_fake_A.png
        ├── epoch002_fake_B.png
        ├── epoch002_idt_A.png
        ├── epoch002_idt_B.png
        ├── epoch002_real_A.png
        ├── epoch002_real_B.png
        ├── epoch002_rec_A.png
        └── epoch002_rec_B.png
```

#### Visualize Training

[VisualDL](https://github.com/PaddlePaddle/VisualDL) is a visual analysis tool developed for deep learning model development, providing real-time trend visualization of key metrics, sample training intermediate process visualization, network structure visualization, etc. It can visually show the relationship between the effects of super participant models and assist in efficient tuning.

Please make sure that you have installed [VisualDL](https://github.com/PaddlePaddle/VisualDL). Refer to the [VisualDL installation guide](https://github.com/PaddlePaddle/VisualDL/blob/develop/README.md#Installation).

Use the [VisualDL](https://github.com/PaddlePaddle/VisualDL) to record the metrics or images generated by the training process by adding the command `enable_visualdl: True` to the configuration file cyclegan_cityscapes.yaml, and run the corresponding command to monitor the training process in real time.

<div align='center'>
  <img src='https://user-images.githubusercontent.com/48054808/122736527-b786ab80-d2b2-11eb-96f8-235f6bbfba5a.png' width=60%>
</div>



If you want to customize the content of the [VisualDL](https://github.com/PaddlePaddle/VisualDL) visualization, you can go to . /PaddleGAN/ppgan/engine/trainer.py.

Launch  [VisualDL](https://github.com/PaddlePaddle/VisualDL) locally by:

```
visualdl --logdir output_dir/CycleGANModel-2020-10-29-09-21/
```

Please refer to the [VisualDL User's Guide](https://github.com/PaddlePaddle/VisualDL/blob/develop/docs/components/README.md) for more guidance on how to start and use those visualization functions.

#### Resume Training

The checkpoint of the previous epoch is saved in `output_dir` by default during the training process to facilitate resuming the training.

In this demo, cyclegan's training will save checkpoint every five epochs by default, and if you want to change the number of epochs, you can go to the **config file to adjust the `interval` paramter**.

<div align='center'>
  <img src='https://user-images.githubusercontent.com/48054808/122886954-fda34400-d372-11eb-91a0-cd0e8328335f.png' width=60%>
</div>

```
python -u tools/main.py --config-file configs/cyclegan_cityscapes.yaml --resume your_checkpoint_path
```
- `--resume (str)`: path of checkpoint。

### 2. Multi-Card Training

```
CUDA_VISIBLE_DEVICES=0,1 python -m paddle.distributed.launch tools/main.py --config-file configs/cyclegan_cityscapes.yaml
```

## Evaluation
```
python tools/main.py --config-file configs/cyclegan_cityscapes.yaml --evaluate-only --load your_weight_path
```

#### Args
- `--evaluate-only`: If or not to make predictions only
- `--load (str)`: path of the weight

