# Copyright (c) 2022 PaddlePaddle Authors. All Rights Reserve.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import os
import sys
import argparse

sys.path.insert(0, os.getcwd())

import paddle
from ppgan.apps import InvDNPredictor

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--output_path",
                        type=str,
                        default='output_dir',
                        help="path to output image dir")

    parser.add_argument("--weight_path",
                        type=str,
                        default=None,
                        help="path to model checkpoint path")

    parser.add_argument("--seed",
                        type=int,
                        default=None,
                        help="sample random seed for model's image generation")

    parser.add_argument('--images_path',
                        default=None,
                        required=True,
                        type=str,
                        help='Single image or images directory.')

    parser.add_argument("--cpu",
                        dest="cpu",
                        action="store_true",
                        help="cpu mode.")

    parser.add_argument(
        "--disable_mc",
        action="store_true",
        help=
        "Disable the Monte Carlo Self Ensemble in the paper to boost the speed during test. Performance may degrade."
    )

    args = parser.parse_args()

    if args.cpu:
        paddle.set_device('cpu')

    predictor = InvDNPredictor(output_path=args.output_path,
                               weight_path=args.weight_path,
                               seed=args.seed)
    predictor.run(images_path=args.images_path, disable_mc=args.disable_mc)
