```eval_rst
.. _demo_ml_dataset:

```

# MovieLens数据集

[MovieLens 数据集](http://grouplens.org/datasets/movielens/)由GroupLens Research实验室搜集整理。
该数据集包含一些用户信息、电影信息以及电影评分\[1-5\]。根据数据量规模，该数据及有很多不同的版本。
我们用[MovieLens 百万数据集](http://files.grouplens.org/datasets/movielens/ml-1m.zip)作为示例数据
集，其中包含6,000位用户对4,000部电影的1,000,000条评价。该数据集于2003年2月发布。

## 数据集特征

在[ml-1m 数据集](http://files.grouplens.org/datasets/movielens/ml-1m.zip)中有许多的特征。在[ml-1m 数据集]
(http://files.grouplens.org/datasets/movielens/ml-1m.zip)中的这些数据文件(含有".dat"的后缀)实际上是CSV文件，
分隔符为"::"。以下我们翻译数据集网站中README文件的描述:

### 评分文件描述(ratings.dat)


所有的评分数据都包含在"ratings.dat"文件中，遵循如下的格式:

用户ID::电影ID::评分::时间戳

- 用户ID范围从1到6040
- 电影ID范围从1到3952
- 评分被调整为5星的规模(只允许整数的星级)
- 时间戳表示为从1970-01-01(UTC)来的秒数，与time(2)的返回值一致
- 每位用户至少有20条评分

### 用户文件描述(users.dat)

所有的用户信息都包含在"users.dat"文件中，遵循如下的格式:

用户ID::性别::年龄::职业::邮编

所有的人口统计学信息由用户自愿提供，没有进行正确性的检查。只有含有人
口统计学信息的用户才被包含在数据集中。

- 性别，用"M"表示男性，"F"表示女性
- 年龄从下列列表范围中选取:

	*   1:	"18岁以下"
	*  18:	"18-24岁"
	*  25:	"25-34岁"
	*  35:	"35-44岁"
	*  45:	"45-49岁"
	*  50:	"50-55岁"
	*  56:	"56+"

- 职业从下面所列中选择:

	*   0:  "其他"或不确定
	*   1:  "学术/教育工作者"
	*   2:  "艺术家"
	*   3:  "文书工作/管理员"
	*   4:  "大学生/研究生"
	*   5:  "客户服务"
	*   6:  "医生/医疗保健"
	*   7:  "行政工作/管理人员"
	*   8:  "农民"
	*   9:  "操持家务者"
	*  10:  "高中毕业生"
	*  11:  "律师"
	*  12:  "程序员"
	*  13:  "退休人员"
	*  14:  "销售/市场"
	*  15:  "科学家"
	*  16:  "自由职业者"
	*  17:  "技术员/工程师"
	*  18:  "推销员/手工艺者"
	*  19:  "无业人士"
	*  20:  "作家"

### 电影文件描述(movies.dat)

所有的电影信息都包含在"movies.dat"文件中，遵循如下的格式:

电影ID::电影名称::电影类型

- 电影名称（包括发行时间）与IMDB网站提供的一致
- 电影类型如符合多种用管道符号|分割，选自下列类型:

	*	动作片
	*	冒险片
	*	动画片
	*	儿童片
	*	喜剧片
	*	犯罪片
	*	纪录片
	*	戏剧
	*	奇幻片
	*	黑色电影
	*	恐怖片
	*	音乐剧
	*	悬疑片
	*	浪漫片
	*	科幻片
	*	惊险电影
	*	战争片
	*	西部片

- 由于意外的副本记录和测试记录，有些电影ID可能与实际电影不相符合
- 电影大部分是手工输入数据，因此可能会有一些错误和不一致发生
