# 推理Benchmark

## 环境准备
- 测试环境:
  - CUDA 10.1
  - CUDNN 7.6
  - TensorRT-6.0.1
  - PaddlePaddle v2.0.1
  - GPU分别为: Tesla V100和Windows 1080Ti和TX2
- 测试方式:
  - 为了方便比较不同模型的推理速度，输入采用同样大小的图片，为 3x640x640，采用 `demo/000000014439_640x640.jpg` 图片。
  - Batch Size=1
  - 去掉前100轮warmup时间，测试100轮的平均时间，单位ms/image，包括网络计算时间、数据拷贝至CPU的时间。
  - 采用Fluid C++预测引擎: 包含Fluid C++预测、Fluid-TensorRT预测，下面同时测试了Float32 (FP32) 和Float16 (FP16)的推理速度。

**注意：**TensorRT中固定尺寸和动态尺寸区别请参考文档[TENSOR教程](TENSOR_RT.md)。由于固定尺寸下对两阶段模型支持不完善，所以faster rcnn模型采用动态尺寸测试。固定尺寸和动态尺寸支持融合的OP不完全一样，因此同一个模型在固定尺寸和动态尺寸下测试的性能可能会有一点差异。

## 推理速度

### V100

| 模型                                         | 是否固定尺寸 | 入网尺寸     | paddle\_inference   | trt\_fp32   | trt\_fp16   |
| ------------------------------------------ | ------ | -------- | ---------- | ---------- | ---------- |
| ppyolo\_r50vd\_dcn\_1x\_coco               | 是      | 608x608  | 20.77  | 18.40443   | 13.532618  |
| yolov3\_mobilenet\_v1\_270e\_coco          | 是      | 608x608  | 9.74   | 8.607459   | 6.275342   |
| ssd\_mobilenet\_v1\_300\_120e\_voc         | 是      | 300x300  | 5.17   | 4.428614   | 4.292153   |
| ttfnet\_darknet53\_1x\_coco                | 是      | 512x512  | 10.14   | 8.708397   | 5.551765   |
| fcos\_dcn\_r50\_fpn\_1x\_coco              | 是      | 640x640  | 35.47  | 35.023315  | 34.24144   |
| faster\_rcnn\_r50\_fpn\_1x\_coco           | 否      | 640x640  | 27.99  | 26.151001  | 21.922865  |
| yolov3\_darknet53\_270e\_coco              | 是      | 608x608  | 17.84  | 15.431566  | 9.861447   |
| faster\_rcnn\_r50\_fpn\_1x\_coco(800x1312) | 否      | 800x1312 | 32.49  | 25.536572  | 21.696611  |


### Windows 1080Ti
| 模型                                         | 是否固定尺寸 | 入网尺寸     | paddle\_inference      | trt\_fp32   | trt\_fp16  |
| ------------------------------------------ | ------ | -------- | ---------- | ---------- | --------- |
| ppyolo\_r50vd\_dcn\_1x\_coco               | 是      | 608x608  | 38.06  | 31.401291  | 31.939096 |
| yolov3\_mobilenet\_v1\_270e\_coco          | 是      | 608x608  | 14.51  | 11.22542   | 11.125602 |
| ssd\_mobilenet\_v1\_300\_120e\_voc         | 是      | 300x300  | 16.47  | 13.874813  | 13.761724 |
| ttfnet\_darknet53\_1x\_coco                | 是      | 512x512  | 21.83  | 17.144808  | 17.092379 |
| fcos\_dcn\_r50\_fpn\_1x\_coco              | 是      | 640x640  | 71.88  | 69.930206  | 69.523048 |
| faster\_rcnn\_r50\_fpn\_1x\_coco           | 否      | 640x640  | 50.74  | 57.172909  | 62.081978 |
| yolov3\_darknet53\_270e\_coco              | 是      | 608x608  | 30.26  | 23.915573  | 24.019217 |
| faster\_rcnn\_r50\_fpn\_1x\_coco(800x1312) | 否      | 800x1312 | 50.31  | 57.613659  | 62.050724 |

### nv jetson
| 模型                                         | 是否固定尺寸 | 入网尺寸     | paddle\_inference   | trt\_fp32   | trt\_fp16   |
| ------------------------------------------ | ------ | -------- | ---------- | ---------- | ---------- |
| ppyolo\_r50vd\_dcn\_1x\_coco               | 是      | 608x608  | 111.80  | 99.40332   | 48.047401  |
| yolov3\_mobilenet\_v1\_270e\_coco          | 是      | 608x608  | 48.76  | 43.832623  | 18.410919  |
| ssd\_mobilenet\_v1\_300\_120e\_voc         | 是      | 300x300  | 10.52  | 8.840097   | 8.765652   |
| ttfnet\_darknet53\_1x\_coco                | 是      | 512x512  | 73.77  | 64.025124  | 31.464737  |
| fcos\_dcn\_r50\_fpn\_1x\_coco              | 是      | 640x640  | 217.11 | 214.381866 | 205.783844 |
| faster\_rcnn\_r50\_fpn\_1x\_coco           | 否      | 640x640  | 169.45 | 158.919266 | 119.253937 |
| yolov3\_darknet53\_270e\_coco              | 是      | 608x608  | 121.61 | 110.29866  | 42.379051  |
| faster\_rcnn\_r50\_fpn\_1x\_coco(800x1312) | 否      | 800x1312 | 228.07 | 156.393372 | 117.026932 |
